/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.internal.ObjectUtil;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class MultiByteHttpData
extends AbstractHttpData
implements FileUpload {
    private static final Logger log = Logger.getLogger(MultiByteHttpData.class);
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int BUFFER_SIZE = Integer.parseInt(System.getProperty("quarkus.rest.client.multipart-buffer-size", String.valueOf(16384)));
    private Flow.Subscription subscription;
    private String filename;
    private String contentType;
    private String contentTransferEncoding;
    private final ByteBuf buffer = VertxByteBufAllocator.DEFAULT.heapBuffer(BUFFER_SIZE, BUFFER_SIZE);
    private final Context context;
    private volatile boolean done = false;
    private boolean paused = false;
    private int awaitedBytes;

    public MultiByteHttpData(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, Multi<Byte> content, Consumer<Throwable> errorHandler, Context context, Runnable resumption) {
        super(name, charset, 0L);
        this.context = context;
        this.setFilename(filename);
        this.setContentType(contentType);
        this.setContentTransferEncoding(contentTransferEncoding);
        ExecutorWithContext contextualExecutor = new ExecutorWithContext(context);
        content.emitOn(contextualExecutor).runSubscriptionOn(contextualExecutor).subscribe().with(subscription -> {
            this.subscription = subscription;
            subscription.request(BUFFER_SIZE);
        }, b -> {
            this.buffer.writeByte(b.byteValue());
            if (this.paused && (this.done || this.buffer.readableBytes() >= this.awaitedBytes)) {
                this.paused = false;
                this.awaitedBytes = 0;
                resumption.run();
            }
        }, th -> {
            log.error((Object)"Multi<Byte> used to send a multipart message failed", (Throwable)th);
            this.done = true;
            errorHandler.accept((Throwable)th);
        }, () -> {
            this.done = true;
            if (this.paused) {
                this.paused = false;
                resumption.run();
            }
        });
    }

    void suspend(int awaitedBytes) {
        this.awaitedBytes = awaitedBytes;
        this.paused = true;
    }

    @Override
    public void setContent(ByteBuf buffer) throws IOException {
        throw new IllegalStateException("setting content of MultiByteHttpData is not supported");
    }

    @Override
    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        throw new IllegalStateException("adding content to MultiByteHttpData is not supported");
    }

    @Override
    public void setContent(File file) throws IOException {
        throw new IllegalStateException("setting content of MultiByteHttpData is not supported");
    }

    @Override
    public void setContent(InputStream inputStream) throws IOException {
        throw new IllegalStateException("setting content of MultiByteHttpData is not supported");
    }

    @Override
    public void delete() {
    }

    @Override
    public byte[] get() throws IOException {
        throw new IllegalStateException("getting all the contents of a MultiByteHttpData is not supported");
    }

    @Override
    public ByteBuf getByteBuf() {
        throw new IllegalStateException("getting all the contents of a MultiByteHttpData is not supported");
    }

    public boolean isReady(int chunkSize) {
        return this.done || this.buffer.readableBytes() >= chunkSize;
    }

    @Override
    public ByteBuf getChunk(int toRead) {
        if (Vertx.currentContext() != this.context) {
            throw new IllegalStateException("MultiByteHttpData invoked on an invalid context : " + String.valueOf(Vertx.currentContext()) + ", thread: " + String.valueOf(Thread.currentThread()));
        }
        if (this.buffer.readableBytes() == 0 && this.done) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf result = VertxByteBufAllocator.DEFAULT.heapBuffer(toRead, toRead);
        while (!(toRead <= 0 || this.buffer.readableBytes() == 0 && this.done)) {
            int readBytes = Math.min(this.buffer.readableBytes(), toRead);
            result.writeBytes(this.buffer.readBytes(readBytes));
            this.buffer.discardReadBytes();
            this.subscription.request(readBytes);
            toRead -= readBytes;
        }
        return result;
    }

    @Override
    public String getString() {
        throw new IllegalStateException("Reading MultiByteHttpData as String is not supported");
    }

    @Override
    public String getString(Charset encoding) {
        throw new IllegalStateException("Reading MultiByteHttpData as String is not supported");
    }

    @Override
    public boolean renameTo(File dest) {
        throw new IllegalStateException("Renaming destination file for MultiByteHttpData is not supported");
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public FileUpload copy() {
        throw new IllegalStateException("Copying MultiByteHttpData is not supported");
    }

    @Override
    public FileUpload duplicate() {
        throw new IllegalStateException("Duplicating MultiByteHttpData is not supported");
    }

    @Override
    public FileUpload retainedDuplicate() {
        throw new IllegalStateException("Duplicating MultiByteHttpData is not supported");
    }

    @Override
    public FileUpload replace(ByteBuf content) {
        throw new IllegalStateException("Replacing MultiByteHttpData is not supported");
    }

    @Override
    public FileUpload retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FileUpload retain() {
        super.retain();
        return this;
    }

    @Override
    public FileUpload touch() {
        this.touch(null);
        return this;
    }

    @Override
    public FileUpload touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        return System.identityHashCode(this) == System.identityHashCode(o);
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof MultiByteHttpData)) {
            throw new ClassCastException("Cannot compare " + String.valueOf((Object)this.getHttpDataType()) + " with " + String.valueOf((Object)o.getHttpDataType()));
        }
        return this.compareTo((MultiByteHttpData)o);
    }

    @Override
    public int compareTo(MultiByteHttpData o) {
        return Integer.compare(System.identityHashCode(this), System.identityHashCode(o));
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.FileUpload;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = ObjectUtil.checkNotNull(filename, "filename");
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = ObjectUtil.checkNotNull(contentType, "contentType");
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    @Override
    public long length() {
        return (long)this.buffer.readableBytes() + super.length();
    }

    public String toString() {
        return String.valueOf(HttpHeaderNames.CONTENT_DISPOSITION) + ": " + String.valueOf(HttpHeaderValues.FORM_DATA) + "; " + String.valueOf(HttpHeaderValues.NAME) + "=\"" + this.getName() + "\"; " + String.valueOf(HttpHeaderValues.FILENAME) + "=\"" + this.filename + "\"\r\n" + String.valueOf(HttpHeaderNames.CONTENT_TYPE) + ": " + this.contentType + (String)(this.getCharset() != null ? "; " + String.valueOf(HttpHeaderValues.CHARSET) + "=" + this.getCharset().name() + "\r\n" : "\r\n") + String.valueOf(HttpHeaderNames.CONTENT_LENGTH) + ": " + this.length() + "\r\nCompleted: " + this.isCompleted();
    }

    static {
        if (BUFFER_SIZE < 16384) {
            throw new IllegalStateException("quarkus.rest.client.multipart-buffer-size cannot be lower than 16384");
        }
    }

    static class ExecutorWithContext
    implements Executor {
        Context context;

        public ExecutorWithContext(Context context) {
            this.context = context;
        }

        @Override
        public void execute(Runnable command) {
            if (Vertx.currentContext() == this.context) {
                command.run();
            } else {
                this.context.runOnContext(v -> command.run());
            }
        }
    }
}

