/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.headers;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.reactive.common.util.HeaderParameterParser;

public class MediaTypeHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    public static final MediaTypeHeaderDelegate INSTANCE = new MediaTypeHeaderDelegate();
    private static final int MAX_MT_CACHE_SIZE = 200;
    private static final char[] quotedChars = "()<>@,;:\\\"/[]?= \t\r\n".toCharArray();
    private static final Map<String, MediaType> map = new ConcurrentHashMap<String, MediaType>();
    private static final Map<MediaType, String> reverseMap = new ConcurrentHashMap<MediaType, String>();

    protected static boolean isValid(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\n': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': {
                    return false;
                }
            }
        }
        return true;
    }

    public static MediaType parse(String type) {
        MediaType result = map.get(type);
        if (result == null) {
            result = MediaTypeHeaderDelegate.internalParse(type);
            int size = map.size();
            if (size >= 200) {
                map.clear();
                reverseMap.clear();
            }
            map.put(type, result);
            reverseMap.put(result, MediaTypeHeaderDelegate.internalToString(result));
        }
        return result;
    }

    private static MediaType internalParse(String type) {
        int typeIndex = type.indexOf(47);
        int paramIndex = type.indexOf(59);
        String major = null;
        String subtype = null;
        if (typeIndex < 0) {
            major = type;
            if (paramIndex > -1) {
                major = major.substring(0, paramIndex);
            }
            if (!"*".equals(major)) {
                throw new IllegalArgumentException("Failed to parse media type " + type);
            }
            subtype = "*";
        } else {
            major = type.substring(0, typeIndex);
            if (paramIndex > -1) {
                if (typeIndex + 1 > paramIndex) {
                    throw new IllegalArgumentException("Failed to parse media type " + type);
                }
                subtype = type.substring(typeIndex + 1, paramIndex);
            } else {
                subtype = type.substring(typeIndex + 1);
            }
        }
        if (major.length() < 1 || subtype.length() < 1) {
            throw new IllegalArgumentException("Failed to parse media type " + type);
        }
        if (!MediaTypeHeaderDelegate.isValid(major) || !MediaTypeHeaderDelegate.isValid(subtype)) {
            throw new IllegalArgumentException("Failed to parse media type " + type);
        }
        String params = null;
        if (paramIndex > -1) {
            params = type.substring(paramIndex + 1);
        }
        if (params != null && !params.equals("")) {
            HashMap<String, String> typeParams = new HashMap<String, String>();
            int start = 0;
            while (start < params.length()) {
                start = HeaderParameterParser.setParam(typeParams, params, start);
            }
            return new MediaType(major, subtype, typeParams);
        }
        return new MediaType(major, subtype);
    }

    public static boolean quoted(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (char q : quotedChars) {
                if (c != q) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MediaType fromString(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("Media type was null");
        }
        return MediaTypeHeaderDelegate.parse(type);
    }

    @Override
    public String toString(MediaType o) {
        if (o == null) {
            throw new IllegalArgumentException("Param was null");
        }
        MediaType type = o;
        String result = reverseMap.get(type);
        if (result == null) {
            result = MediaTypeHeaderDelegate.internalToString(type);
            int size = reverseMap.size();
            if (size >= 200) {
                reverseMap.clear();
                map.clear();
            }
            reverseMap.put(type, result);
            map.put(result, type);
        }
        return result;
    }

    private static String internalToString(MediaType type) {
        StringBuilder buf = new StringBuilder(type.getType().length() + type.getSubtype().length() + 1);
        buf.append(type.getType().toLowerCase()).append('/').append(type.getSubtype().toLowerCase());
        if (type.getParameters() == null || type.getParameters().size() == 0) {
            return buf.toString();
        }
        for (String name : type.getParameters().keySet()) {
            buf.append(';').append(name).append('=');
            String val = type.getParameters().get(name);
            if (MediaTypeHeaderDelegate.quoted(val)) {
                buf.append('\"').append(val).append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }
}

