/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Variant;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.jaxrs.RestResponseImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public abstract class AbstractRestResponseBuilder<T>
extends RestResponse.ResponseBuilder<T> {
    static final Map<Integer, String> defaultReasonPhrases = new HashMap<Integer, String>();
    protected int status = -1;
    protected String reasonPhrase;
    protected Object entity;
    protected MultivaluedTreeMap<String, Object> metadata = new CaseInsensitiveMap<Object>();
    protected Annotation[] entityAnnotations;

    public static SimpleDateFormat getDateFormatRFC822() {
        SimpleDateFormat dateFormatRFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormatRFC822.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormatRFC822;
    }

    public static String createVaryHeader(List<Variant> variants) {
        boolean accept = false;
        boolean acceptLanguage = false;
        boolean acceptEncoding = false;
        for (Variant variant : variants) {
            if (variant.getMediaType() != null) {
                accept = true;
            }
            if (variant.getLanguage() != null) {
                acceptLanguage = true;
            }
            if (variant.getEncoding() == null) continue;
            acceptEncoding = true;
        }
        Object vary = null;
        if (accept) {
            vary = "Accept";
        }
        if (acceptLanguage) {
            vary = vary == null ? "Accept-Language" : (String)vary + ", Accept-Language";
        }
        if (acceptEncoding) {
            vary = vary == null ? "Accept-Encoding" : (String)vary + ", Accept-Encoding";
        }
        return vary;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setEntityAnnotations(Annotation[] entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    @Override
    public RestResponseImpl<T> build() {
        return this.populateResponse(new RestResponseImpl());
    }

    public RestResponseImpl<T> build(boolean copyHeaders) {
        return this.populateResponse(new RestResponseImpl(), copyHeaders);
    }

    public <OtherT extends RestResponseImpl<T>> OtherT populateResponse(OtherT response) {
        return this.populateResponse(response, true);
    }

    public <OtherT extends RestResponseImpl<T>> OtherT populateResponse(OtherT response, boolean copyHeaders) {
        response.entity = this.entity;
        response.status = this.entity == null && this.status == -1 ? 204 : (this.status == -1 ? 200 : this.status);
        response.reasonPhrase = this.reasonPhrase;
        if (copyHeaders) {
            response.headers = new CaseInsensitiveMap<Object>();
            response.headers.putAll((Map<String, List<Object>>)this.metadata);
        } else {
            response.headers = this.metadata;
        }
        response.entityAnnotations = this.entityAnnotations;
        return response;
    }

    public void setAllHeaders(MultivaluedMap<String, String> values) {
        for (Map.Entry i : values.entrySet()) {
            for (String v : (List)i.getValue()) {
                this.metadata.add((String)i.getKey(), v);
            }
        }
    }

    protected abstract AbstractRestResponseBuilder<T> doClone();

    @Override
    public AbstractRestResponseBuilder<T> clone() {
        AbstractRestResponseBuilder<T> responseBuilder = this.doClone();
        responseBuilder.status = this.status;
        responseBuilder.reasonPhrase = this.reasonPhrase;
        responseBuilder.entity = this.entity;
        responseBuilder.metadata = new CaseInsensitiveMap<Object>();
        responseBuilder.metadata.putAll((Map<String, List<Object>>)this.metadata);
        return responseBuilder;
    }

    @Override
    public <Ret extends T> RestResponse.ResponseBuilder<Ret> status(int status, String reasonPhrase) {
        this.status = status;
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    @Override
    public <Ret extends T> RestResponse.ResponseBuilder<Ret> status(int status) {
        return this.status(status, defaultReasonPhrases.get(status));
    }

    @Override
    public RestResponse.ResponseBuilder<T> entity(T entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> entity(T entity, Annotation[] annotations) {
        this.entity = entity;
        this.entityAnnotations = annotations;
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> type(MediaType type) {
        if (type == null) {
            this.metadata.remove("Content-Type");
            return this;
        }
        this.metadata.putSingle("Content-Type", type);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> type(String type) {
        if (type == null) {
            this.metadata.remove("Content-Type");
            return this;
        }
        this.metadata.putSingle("Content-Type", type);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> variant(Variant variant) {
        if (variant == null) {
            this.type((String)null);
            this.language((String)null);
            this.metadata.remove("Content-Encoding");
            return this;
        }
        this.type(variant.getMediaType());
        this.language(variant.getLanguage());
        if (variant.getEncoding() != null) {
            this.metadata.putSingle("Content-Encoding", variant.getEncoding());
        } else {
            this.metadata.remove("Content-Encoding");
        }
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> variants(List<Variant> variants) {
        if (variants == null) {
            this.metadata.remove("Vary");
            return this;
        }
        String vary = AbstractRestResponseBuilder.createVaryHeader(variants);
        this.metadata.putSingle("Vary", vary);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> language(String language) {
        if (language == null) {
            this.metadata.remove("Content-Language");
            return this;
        }
        this.metadata.putSingle("Content-Language", language);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> tag(EntityTag tag) {
        if (tag == null) {
            this.metadata.remove("ETag");
            return this;
        }
        this.metadata.putSingle("ETag", tag);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> tag(String tag) {
        if (tag == null) {
            this.metadata.remove("ETag");
            return this;
        }
        return this.tag(new EntityTag(tag));
    }

    @Override
    public RestResponse.ResponseBuilder<T> lastModified(Date lastModified) {
        if (lastModified == null) {
            this.metadata.remove("Last-Modified");
            return this;
        }
        this.metadata.putSingle("Last-Modified", lastModified);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> cacheControl(CacheControl cacheControl) {
        if (cacheControl == null) {
            this.metadata.remove("Cache-Control");
            return this;
        }
        this.metadata.putSingle("Cache-Control", cacheControl);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> header(String name, Object value) {
        if (value == null) {
            this.metadata.remove(name);
            return this;
        }
        this.metadata.add(name, value);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> cookie(NewCookie ... cookies) {
        if (cookies == null) {
            this.metadata.remove("Set-Cookie");
            return this;
        }
        for (NewCookie cookie : cookies) {
            this.metadata.add("Set-Cookie", cookie);
        }
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> language(Locale language) {
        if (language == null) {
            this.metadata.remove("Content-Language");
            return this;
        }
        this.metadata.putSingle("Content-Language", language);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> expires(Date expires) {
        if (expires == null) {
            this.metadata.remove("Expires");
            return this;
        }
        this.metadata.putSingle("Expires", AbstractRestResponseBuilder.getDateFormatRFC822().format(expires));
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> allow(String ... methods) {
        if (methods == null) {
            return this.allow((Set<String>)null);
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(methods));
        return this.allow(set);
    }

    @Override
    public RestResponse.ResponseBuilder<T> allow(Set<String> methods) {
        HeaderUtil.setAllow(this.metadata, methods);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> encoding(String encoding) {
        if (encoding == null) {
            this.metadata.remove("Content-Encoding");
            return this;
        }
        this.metadata.putSingle("Content-Encoding", encoding);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> variants(Variant ... variants) {
        return this.variants(Arrays.asList(variants));
    }

    @Override
    public RestResponse.ResponseBuilder<T> links(Link ... links) {
        if (links == null) {
            this.metadata.remove("Link");
            return this;
        }
        for (Link link : links) {
            this.metadata.add("Link", link);
        }
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> link(URI uri, String rel) {
        Link link = Link.fromUri(uri).rel(rel).build(new Object[0]);
        this.metadata.add("Link", link);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> link(String uri, String rel) {
        Link link = Link.fromUri(uri).rel(rel).build(new Object[0]);
        this.metadata.add("Link", link);
        return this;
    }

    @Override
    public RestResponse.ResponseBuilder<T> replaceAll(MultivaluedMap<String, Object> headers) {
        this.metadata.clear();
        if (headers == null) {
            return this;
        }
        this.metadata.putAll((Map<String, List<Object>>)headers);
        return this;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    static {
        defaultReasonPhrases.put(100, "Continue");
        defaultReasonPhrases.put(101, "Switching Protocols");
        defaultReasonPhrases.put(102, "Processing");
        defaultReasonPhrases.put(103, "Early Hints");
        defaultReasonPhrases.put(200, "OK");
        defaultReasonPhrases.put(201, "Created");
        defaultReasonPhrases.put(202, "Accepted");
        defaultReasonPhrases.put(203, "Non-Authoritative Information");
        defaultReasonPhrases.put(204, "No Content");
        defaultReasonPhrases.put(205, "Reset Content");
        defaultReasonPhrases.put(206, "Partial Content");
        defaultReasonPhrases.put(208, "Already Reported");
        defaultReasonPhrases.put(226, "IM Used");
        defaultReasonPhrases.put(300, "Multiple Choices");
        defaultReasonPhrases.put(301, "Moved Permanently");
        defaultReasonPhrases.put(302, "Found");
        defaultReasonPhrases.put(303, "See Other");
        defaultReasonPhrases.put(304, "Not Modified");
        defaultReasonPhrases.put(305, "Use Proxy");
        defaultReasonPhrases.put(307, "Temporary Redirect");
        defaultReasonPhrases.put(308, "Permanent Redirect");
        defaultReasonPhrases.put(400, "Bad Request");
        defaultReasonPhrases.put(401, "Unauthorized");
        defaultReasonPhrases.put(402, "Payment Required");
        defaultReasonPhrases.put(403, "Forbidden");
        defaultReasonPhrases.put(404, "Not Found");
        defaultReasonPhrases.put(405, "Method Not Allowed");
        defaultReasonPhrases.put(406, "Not Acceptable");
        defaultReasonPhrases.put(407, "Proxy Authentication Required");
        defaultReasonPhrases.put(408, "Request Timeout");
        defaultReasonPhrases.put(409, "Conflict");
        defaultReasonPhrases.put(410, "Gone");
        defaultReasonPhrases.put(411, "Length Required");
        defaultReasonPhrases.put(412, "Precondition Failed");
        defaultReasonPhrases.put(413, "Request Entity Too Large");
        defaultReasonPhrases.put(414, "Request-URI Too Long");
        defaultReasonPhrases.put(415, "Unsupported Media Type");
        defaultReasonPhrases.put(416, "Requested Range Not Satisfiable");
        defaultReasonPhrases.put(417, "Expectation Failed");
        defaultReasonPhrases.put(421, "Misdirected Request");
        defaultReasonPhrases.put(426, "Upgrade Required");
        defaultReasonPhrases.put(428, "Precondition Required");
        defaultReasonPhrases.put(429, "Too Many Requests");
        defaultReasonPhrases.put(431, "Request Header Fields Too Large");
        defaultReasonPhrases.put(451, "Unavailable For Legal Reasons");
        defaultReasonPhrases.put(500, "Internal Server Error");
        defaultReasonPhrases.put(501, "Not Implemented");
        defaultReasonPhrases.put(502, "Bad Gateway");
        defaultReasonPhrases.put(503, "Service Unavailable");
        defaultReasonPhrases.put(504, "Gateway Timeout");
        defaultReasonPhrases.put(505, "HTTP Version Not Supported");
        defaultReasonPhrases.put(506, "Variant Also Negotiates");
        defaultReasonPhrases.put(507, "Insufficient Storage");
        defaultReasonPhrases.put(508, "Loop Detected");
        defaultReasonPhrases.put(510, "Not Extended");
        defaultReasonPhrases.put(511, "Network Authentication Required");
    }
}

