/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.reactive.common.jaxrs.LinkImpl;

public class LinkBuilderImpl
implements Link.Builder {
    protected final Map<String, String> map = new HashMap<String, String>();
    protected UriBuilder uriBuilder;
    protected URI baseUri;

    @Override
    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromUri(link.getUri());
        this.map.clear();
        this.map.putAll(link.getParams());
        return this;
    }

    @Override
    public Link.Builder link(String link) {
        Link l = LinkImpl.valueOf(link);
        return this.link(l);
    }

    @Override
    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder.clone();
        return this;
    }

    @Override
    public Link.Builder uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI was null");
        }
        this.uriBuilder = UriBuilder.fromUri(uri);
        return this;
    }

    @Override
    public Link.Builder uri(String uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("URI was null");
        }
        this.uriBuilder = UriBuilder.fromUri(uri);
        return this;
    }

    @Override
    public Link.Builder rel(String rel) {
        if (rel == null) {
            throw new IllegalArgumentException("param was null");
        }
        String rels = this.map.get("rel");
        this.param("rel", (String)(rels == null ? rel : rels + " " + rel));
        return this;
    }

    @Override
    public Link.Builder title(String title) {
        if (title == null) {
            throw new IllegalArgumentException("param was null");
        }
        this.param("title", title);
        return this;
    }

    @Override
    public Link.Builder type(String type) {
        if (type == null) {
            throw new IllegalArgumentException("param was null");
        }
        this.param("type", type);
        return this;
    }

    @Override
    public Link.Builder param(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("param was null");
        }
        if (value == null) {
            throw new IllegalArgumentException("param was null");
        }
        this.map.put(name, value);
        return this;
    }

    @Override
    public Link build(Object ... values) throws UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("param was null");
        }
        URI built = null;
        built = this.uriBuilder == null ? this.baseUri : this.uriBuilder.build(values);
        if (!built.isAbsolute() && this.baseUri != null) {
            built = this.baseUri.resolve(built);
        }
        return new LinkImpl(built, this.map);
    }

    @Override
    public Link buildRelativized(URI uri, Object ... values) {
        URI built;
        if (uri == null) {
            throw new IllegalArgumentException("URI was null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values was null");
        }
        URI with = built = this.uriBuilder.build(values);
        if (this.baseUri != null) {
            with = this.baseUri.resolve(built);
        }
        return new LinkImpl(uri.relativize(with), this.map);
    }

    @Override
    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    @Override
    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }
}

