/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkImpl
extends Link {
    protected final URI uri;
    protected final Map<String, String> map;
    protected static final RuntimeDelegate.HeaderDelegate<Link> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);

    public static Link valueOf(String value) {
        return delegate.fromString(value);
    }

    LinkImpl(URI uri, Map<String, String> map) {
        this.uri = uri;
        this.map = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri(this.uri);
    }

    @Override
    public String getRel() {
        return this.map.get("rel");
    }

    @Override
    public List<String> getRels() {
        String rels = this.map.get("rel");
        return rels == null ? Collections.emptyList() : Arrays.asList(rels.split(" +"));
    }

    @Override
    public String getTitle() {
        return this.map.get("title");
    }

    @Override
    public String getType() {
        return this.map.get("type");
    }

    @Override
    public Map<String, String> getParams() {
        return this.map;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LinkImpl) {
            LinkImpl otherLink = (LinkImpl)other;
            return this.uri.equals(otherLink.uri) && this.map.equals(otherLink.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 89 * hash + (this.map != null ? this.map.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return delegate.toString(this);
    }
}

