/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.headers.LinkHeaders;
import org.jboss.resteasy.reactive.common.jaxrs.StatusTypeImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public class ResponseImpl
extends Response {
    int status;
    String reasonPhrase;
    protected Object entity;
    MultivaluedTreeMap<String, Object> headers;
    InputStream entityStream;
    StatusTypeImpl statusType;
    MultivaluedMap<String, String> stringHeaders;
    Annotation[] entityAnnotations;
    protected boolean consumed;
    protected boolean closed;
    protected boolean buffered;

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.statusType = null;
    }

    @Override
    public Response.StatusType getStatusInfo() {
        if (this.statusType == null) {
            this.statusType = new StatusTypeImpl(this.status, this.reasonPhrase);
        }
        return this.statusType;
    }

    public void setStatusInfo(Response.StatusType statusType) {
        this.statusType = StatusTypeImpl.valueOf(statusType);
        this.status = statusType.getStatusCode();
    }

    @Override
    public Object getEntity() {
        GenericEntity genericEntity;
        this.checkClosed();
        Object object = this.entity;
        if (object instanceof GenericEntity && (genericEntity = (GenericEntity)object).getRawType().equals(genericEntity.getType())) {
            return ((GenericEntity)this.entity).getEntity();
        }
        return this.entity == null ? this.entityStream : this.entity;
    }

    protected void setEntity(Object entity) {
        this.entity = entity;
        if (entity instanceof InputStream) {
            InputStream inputStream;
            this.entityStream = inputStream = (InputStream)entity;
        }
    }

    public InputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(InputStream entityStream) {
        this.entityStream = entityStream;
    }

    protected <T> T readEntity(Class<T> entityType, Type genericType, Annotation[] annotations) {
        if (this.entity != null && entityType.isInstance(this.entity)) {
            return (T)this.entity;
        }
        this.checkClosed();
        throw new ProcessingException("Request could not be mapped to type " + String.valueOf(genericType != null ? genericType : entityType));
    }

    @Override
    public <T> T readEntity(Class<T> entityType) {
        return this.readEntity(entityType, entityType, null);
    }

    @Override
    public <T> T readEntity(GenericType<T> entityType) {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), null);
    }

    @Override
    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return this.readEntity(entityType, entityType, annotations);
    }

    @Override
    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return (T)this.readEntity(entityType.getRawType(), entityType.getType(), annotations);
    }

    @Override
    public boolean hasEntity() {
        this.checkClosed();
        return this.entity != null || this.entityStream != null;
    }

    @Override
    public boolean bufferEntity() {
        this.checkClosed();
        if (this.buffered) {
            return true;
        }
        if (this.entityStream != null && !this.consumed) {
            this.consumed = true;
            if (!this.entityStream.markSupported()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                try {
                    int read;
                    while ((read = this.entityStream.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    this.entityStream.close();
                }
                catch (IOException x) {
                    throw new UncheckedIOException(x);
                }
                this.entityStream = new ByteArrayInputStream(os.toByteArray());
            }
            this.buffered = true;
            return true;
        }
        return false;
    }

    protected void checkClosed() {
        if (this.closed && !this.buffered) {
            throw new IllegalStateException("Response has been closed");
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.entityStream != null) {
                try {
                    this.entityStream.close();
                }
                catch (IOException e) {
                    throw new ProcessingException(e);
                }
            }
        }
    }

    @Override
    public MediaType getMediaType() {
        return HeaderUtil.getMediaType(this.headers);
    }

    @Override
    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.headers);
    }

    @Override
    public int getLength() {
        return HeaderUtil.getLength(this.headers);
    }

    @Override
    public Set<String> getAllowedMethods() {
        return HeaderUtil.getAllowedMethods(this.headers);
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return HeaderUtil.getNewCookies(this.headers);
    }

    @Override
    public EntityTag getEntityTag() {
        return HeaderUtil.getEntityTag(this.headers);
    }

    @Override
    public Date getDate() {
        return HeaderUtil.getDate(this.headers);
    }

    @Override
    public Date getLastModified() {
        return HeaderUtil.getLastModified(this.headers);
    }

    @Override
    public URI getLocation() {
        return HeaderUtil.getLocation(this.headers);
    }

    private LinkHeaders getLinkHeaders() {
        return new LinkHeaders(this.headers);
    }

    @Override
    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getLinkHeaders().getLinks());
    }

    @Override
    public boolean hasLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation) != null;
    }

    @Override
    public Link getLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLinkHeaders().getLinkByRelationship(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink(link);
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        if (this.stringHeaders == null) {
            this.stringHeaders = new CaseInsensitiveMap<String>();
            this.headers.forEach((BiConsumer<String, List<Object>>)((BiConsumer<String, List>)this::populateStringHeaders));
        }
        return this.stringHeaders;
    }

    public void populateStringHeaders(String headerName, List<Object> values) {
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            stringValues.add(HeaderUtil.headerToString(values.get(i)));
        }
        this.stringHeaders.put(headerName, (String)((Object)stringValues));
    }

    @Override
    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString(this.getStringHeaders(), name);
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }
}

