/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.model;

import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResourceInterceptors {
    private InterceptorContainer<ContainerResponseFilter> containerResponseFilters = new InterceptorContainer.Reversed<ContainerResponseFilter>();
    private PreMatchInterceptorContainer<ContainerRequestFilter> containerRequestFilters = new PreMatchInterceptorContainer();
    private InterceptorContainer<WriterInterceptor> writerInterceptors = new InterceptorContainer();
    private InterceptorContainer<ReaderInterceptor> readerInterceptors = new InterceptorContainer();

    public InterceptorContainer<ContainerResponseFilter> getContainerResponseFilters() {
        return this.containerResponseFilters;
    }

    public ResourceInterceptors setContainerResponseFilters(InterceptorContainer<ContainerResponseFilter> containerResponseFilters) {
        this.containerResponseFilters = containerResponseFilters;
        return this;
    }

    public PreMatchInterceptorContainer<ContainerRequestFilter> getContainerRequestFilters() {
        return this.containerRequestFilters;
    }

    public ResourceInterceptors setContainerRequestFilters(PreMatchInterceptorContainer<ContainerRequestFilter> containerRequestFilters) {
        this.containerRequestFilters = containerRequestFilters;
        return this;
    }

    public InterceptorContainer<WriterInterceptor> getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public ResourceInterceptors setWriterInterceptors(InterceptorContainer<WriterInterceptor> writerInterceptors) {
        this.writerInterceptors = writerInterceptors;
        return this;
    }

    public InterceptorContainer<ReaderInterceptor> getReaderInterceptors() {
        return this.readerInterceptors;
    }

    public ResourceInterceptors setReaderInterceptors(InterceptorContainer<ReaderInterceptor> readerInterceptors) {
        this.readerInterceptors = readerInterceptors;
        return this;
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        this.containerRequestFilters.initializeDefaultFactories(factoryCreator);
        this.containerResponseFilters.initializeDefaultFactories(factoryCreator);
        this.readerInterceptors.initializeDefaultFactories(factoryCreator);
        this.writerInterceptors.initializeDefaultFactories(factoryCreator);
    }

    public ResourceInterceptors sort() {
        this.containerRequestFilters.sort();
        this.containerResponseFilters.sort();
        this.writerInterceptors.sort();
        this.readerInterceptors.sort();
        return this;
    }

    public void visitFilters(FiltersVisitor visitor) {
        FiltersVisitor.VisitResult visitResult;
        for (ResourceInterceptor<ContainerRequestFilter> resourceInterceptor : this.containerRequestFilters.getPreMatchInterceptors()) {
            visitResult = visitor.visitPreMatchRequestFilter(resourceInterceptor);
            if (visitResult != FiltersVisitor.VisitResult.ABORT) continue;
            return;
        }
        for (ResourceInterceptor<ContainerRequestFilter> resourceInterceptor : this.containerRequestFilters.getGlobalResourceInterceptors()) {
            visitResult = visitor.visitGlobalRequestFilter(resourceInterceptor);
            if (visitResult != FiltersVisitor.VisitResult.ABORT) continue;
            return;
        }
        for (ResourceInterceptor<ContainerRequestFilter> resourceInterceptor : this.containerRequestFilters.getNameResourceInterceptors()) {
            visitResult = visitor.visitNamedRequestFilter(resourceInterceptor);
            if (visitResult != FiltersVisitor.VisitResult.ABORT) continue;
            return;
        }
        for (ResourceInterceptor<Object> resourceInterceptor : this.containerResponseFilters.getGlobalResourceInterceptors()) {
            visitResult = visitor.visitGlobalResponseFilter(resourceInterceptor);
            if (visitResult != FiltersVisitor.VisitResult.ABORT) continue;
            return;
        }
        for (ResourceInterceptor<Object> resourceInterceptor : this.containerResponseFilters.getNameResourceInterceptors()) {
            visitResult = visitor.visitNamedResponseFilter(resourceInterceptor);
            if (visitResult != FiltersVisitor.VisitResult.ABORT) continue;
            return;
        }
    }

    public static interface FiltersVisitor {
        public VisitResult visitPreMatchRequestFilter(ResourceInterceptor<ContainerRequestFilter> var1);

        public VisitResult visitGlobalRequestFilter(ResourceInterceptor<ContainerRequestFilter> var1);

        public VisitResult visitNamedRequestFilter(ResourceInterceptor<ContainerRequestFilter> var1);

        public VisitResult visitGlobalResponseFilter(ResourceInterceptor<ContainerResponseFilter> var1);

        public VisitResult visitNamedResponseFilter(ResourceInterceptor<ContainerResponseFilter> var1);

        public static enum VisitResult {
            CONTINUE,
            ABORT;

        }
    }
}

