/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.providers.serialisers;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;

public class FileBodyHandler
implements MessageBodyReader<File>,
MessageBodyWriter<File> {
    public static final String PREFIX = "pfx";
    public static final String SUFFIX = "sfx";

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class == type;
    }

    @Override
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return FileBodyHandler.doRead(httpHeaders, entityStream, Files.createTempFile(PREFIX, SUFFIX, new FileAttribute[0]).toFile());
    }

    public static File doRead(MultivaluedMap<String, String> httpHeaders, InputStream entityStream, File file) throws IOException {
        if (HeaderUtil.isContentLengthZero(httpHeaders)) {
            return file;
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            entityStream.transferTo(output);
        }
        return file;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(File uploadFile, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        httpHeaders.add("Content-Length", String.valueOf(uploadFile.length()));
        this.doWrite(uploadFile, entityStream);
    }

    protected void doWrite(File uploadFile, OutputStream out) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));){
            int read;
            byte[] buf = new byte[2048];
            while ((read = ((InputStream)inputStream).read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
    }
}

