/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import jakarta.ws.rs.core.MediaType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.resteasy.reactive.common.headers.MediaTypeHeaderDelegate;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;

public class ServerMediaType {
    private final MediaType[] sortedMediaTypes;
    private final MediaType[] sortedOriginalMediaTypes;
    private final MediaType hardCoded;

    public static List<MediaType> mediaTypesFromArray(String[] mediaTypesStrs) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(mediaTypesStrs.length);
        for (String mediaTypesStr : mediaTypesStrs) {
            mediaTypes.add(MediaTypeHeaderDelegate.INSTANCE.fromString(mediaTypesStr));
        }
        return mediaTypes;
    }

    public ServerMediaType(List<MediaType> mediaTypes, String charset, final boolean deprioritizeWildcards) {
        this.sortedOriginalMediaTypes = mediaTypes.isEmpty() ? new MediaType[]{MediaType.WILDCARD_TYPE} : mediaTypes.toArray(new MediaType[0]);
        this.sortedMediaTypes = new MediaType[this.sortedOriginalMediaTypes.length];
        Arrays.sort(this.sortedOriginalMediaTypes, new Comparator<MediaType>(){

            @Override
            public int compare(MediaType m1, MediaType m2) {
                if (deprioritizeWildcards) {
                    if (m1.isWildcardType() && !m2.isWildcardType()) {
                        return 1;
                    }
                    if (!m1.isWildcardType() && m2.isWildcardType()) {
                        return -1;
                    }
                    if (!m1.isWildcardType() && !m2.isWildcardType()) {
                        if (m1.isWildcardSubtype() && !m2.isWildcardSubtype()) {
                            return 1;
                        }
                        if (!m1.isWildcardSubtype() && m2.isWildcardSubtype()) {
                            return -1;
                        }
                    }
                }
                String qs1s = m1.getParameters().get("qs");
                String qs2s = m2.getParameters().get("qs");
                if (qs1s == null && qs2s == null) {
                    return 0;
                }
                if (qs1s != null) {
                    if (qs2s == null) {
                        return 1;
                    }
                    float q1 = Float.parseFloat(qs1s);
                    float q2 = Float.parseFloat(qs2s);
                    return Float.compare(q2, q1);
                }
                return -1;
            }
        });
        for (int i = 0; i < this.sortedOriginalMediaTypes.length; ++i) {
            MediaType m;
            MediaType existing = this.sortedOriginalMediaTypes[i];
            this.sortedMediaTypes[i] = m = new MediaType(existing.getType(), existing.getSubtype(), charset);
        }
        this.hardCoded = this.sortedMediaTypes.length == 1 && !this.sortedMediaTypes[0].isWildcardType() && !this.sortedMediaTypes[0].isWildcardSubtype() ? this.sortedMediaTypes[0] : null;
    }

    public Map.Entry<MediaType, MediaType> negotiateProduces(String acceptHeader) {
        return this.negotiateProduces(acceptHeader, this.hardCoded);
    }

    public Map.Entry<MediaType, MediaType> negotiateProduces(String acceptHeader, MediaType hardCoded) {
        if (hardCoded != null) {
            return new AbstractMap.SimpleEntry<MediaType, Object>(hardCoded, null);
        }
        MediaType selectedDesired = null;
        MediaType selectedProvided = null;
        if (acceptHeader != null) {
            List<MediaType> parsedAccepted = MediaTypeHelper.parseHeader(acceptHeader);
            MediaTypeHelper.sortByWeight(parsedAccepted);
            String currentClientQ = null;
            int currentServerIndex = Integer.MAX_VALUE;
            if (!parsedAccepted.isEmpty()) {
                for (MediaType desired : parsedAccepted) {
                    if (selectedDesired != null && !Objects.equals(desired.getParameters().get("q"), currentClientQ)) {
                        if (selectedDesired.equals(MediaType.WILDCARD_TYPE)) {
                            return new AbstractMap.SimpleEntry<MediaType, Object>(MediaType.APPLICATION_OCTET_STREAM_TYPE, selectedProvided);
                        }
                        return new AbstractMap.SimpleEntry<MediaType, Object>(selectedDesired, selectedProvided);
                    }
                    for (int j = 0; j < this.sortedMediaTypes.length; ++j) {
                        MediaType provide = this.sortedMediaTypes[j];
                        if (!provide.isCompatible(desired) || selectedDesired != null && j >= currentServerIndex) continue;
                        if (desired.isWildcardType()) {
                            if (selectedDesired != null) continue;
                            selectedDesired = provide;
                        } else if (desired.isWildcardSubtype()) {
                            if (selectedDesired != null) continue;
                            selectedDesired = desired.isCompatible(MediaType.APPLICATION_OCTET_STREAM_TYPE) ? MediaType.APPLICATION_OCTET_STREAM_TYPE : desired;
                        } else {
                            selectedDesired = desired;
                        }
                        selectedProvided = provide;
                        currentServerIndex = j;
                        currentClientQ = desired.getParameters().get("q");
                    }
                }
            }
        }
        if (selectedDesired == null) {
            selectedDesired = this.sortedMediaTypes[0];
        }
        if (selectedDesired.equals(MediaType.WILDCARD_TYPE)) {
            return new AbstractMap.SimpleEntry<MediaType, Object>(MediaType.APPLICATION_OCTET_STREAM_TYPE, selectedProvided);
        }
        return new AbstractMap.SimpleEntry<MediaType, Object>(selectedDesired, selectedProvided);
    }

    public MediaType[] getSortedMediaTypes() {
        return this.sortedMediaTypes;
    }

    public MediaType[] getSortedOriginalMediaTypes() {
        return this.sortedOriginalMediaTypes;
    }
}

