/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import jakarta.ws.rs.core.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.spi.ContentType;

public class EncodedMediaType
implements ContentType {
    final MediaType mediaType;
    final String charset;
    String encoded;

    public EncodedMediaType(MediaType mediaType) {
        String effectiveCharset;
        MediaType effectiveMediaType = mediaType;
        String originalCharset = mediaType.getParameters().get("charset");
        if (MediaTypeHelper.isTextLike(mediaType)) {
            effectiveCharset = originalCharset;
            if (effectiveCharset == null) {
                effectiveCharset = StandardCharsets.UTF_8.name();
            }
        } else {
            effectiveCharset = null;
        }
        this.charset = effectiveCharset;
        if (!Objects.equals(originalCharset, effectiveCharset)) {
            effectiveMediaType = mediaType.withCharset(effectiveCharset);
        }
        this.mediaType = effectiveMediaType;
    }

    public String toString() {
        return this.getEncoded();
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getEncoded() {
        if (this.encoded == null) {
            this.encoded = MediaTypeHelper.toString(this.mediaType);
            return this.encoded;
        }
        return this.encoded;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

