/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.resteasy.reactive.FilePart;
import org.jboss.resteasy.reactive.PathPart;
import org.jboss.resteasy.reactive.common.PreserveTargetException;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.LazyResponse;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartMessageBodyWriter;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriterArray;
import org.jboss.resteasy.reactive.server.jaxrs.WriterInterceptorContextImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerBooleanMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerByteArrayMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerCharArrayMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerCharacterMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerDefaultTextPlainBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFileBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFilePartBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFormUrlEncodedProvider;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerInputStreamMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerNumberMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerPathBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerPathPartBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerReaderBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerStringMessageBodyHandler;
import org.jboss.resteasy.reactive.server.providers.serialisers.StreamingOutputMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;

public class ServerSerialisers
extends Serialisers {
    private static final Consumer<ResteasyReactiveRequestContext> HEADER_FUNCTION = new Consumer<ResteasyReactiveRequestContext>(){

        @Override
        public void accept(ResteasyReactiveRequestContext context) {
            ServerSerialisers.encodeResponseHeaders(context);
        }
    };
    private static final String CONTENT = "Content";
    private static final String CONTENT_LOWER = "content";
    private static final String LOCATION = "Location";
    private static final String TYPE = "Type";
    private static final String TYPE_LOWER = "type";
    private static final String LENGTH = "Length";
    private static final String LENGTH_LOWER = "length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final List<Serialisers.BuiltinReader> BUILTIN_READERS = List.of(new Serialisers.BuiltinReader(String.class, ServerStringMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Boolean.class, ServerBooleanMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(Character.class, ServerCharacterMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(Number.class, ServerNumberMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(InputStream.class, ServerInputStreamMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Reader.class, ServerReaderBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(File.class, ServerFileBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(byte[].class, ServerByteArrayMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Object.class, ServerDefaultTextPlainBodyHandler.class, "text/plain", RuntimeType.SERVER));
    public static final List<Serialisers.BuiltinWriter> BUILTIN_WRITERS = List.of(new Serialisers.BuiltinWriter(String.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Number.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Boolean.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Character.class, ServerStringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Object.class, ServerStringMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(char[].class, ServerCharArrayMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(byte[].class, ServerByteArrayMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(MultivaluedMap.class, ServerFormUrlEncodedProvider.class, "application/x-www-form-urlencoded"), new Serialisers.BuiltinWriter(InputStream.class, ServerInputStreamMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(StreamingOutput.class, StreamingOutputMessageBodyWriter.class, "*/*"), new Serialisers.BuiltinWriter(Reader.class, ServerReaderBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(File.class, ServerFileBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(FilePart.class, ServerFilePartBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(MultipartFormDataOutput.class, MultipartMessageBodyWriter.class, "multipart/form-data"), new Serialisers.BuiltinWriter(Path.class, ServerPathBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(PathPart.class, ServerPathPartBodyHandler.class, "*/*"));
    public static final MessageBodyWriter<?>[] NO_WRITER = new MessageBodyWriter[0];
    public static final MessageBodyReader<?>[] NO_READER = new MessageBodyReader[0];
    private final ConcurrentMap<Class<?>, List<ResourceWriter>> noMediaTypeClassCache = new ConcurrentHashMap();
    private final Function<Class<?>, List<ResourceWriter>> mappingFunction = new Function<Class<?>, List<ResourceWriter>>(){

        @Override
        public List<ResourceWriter> apply(Class<?> aClass) {
            ArrayList<ResourceWriter> writers = new ArrayList<ResourceWriter>();
            HashSet<Class> seenInterfaces = new HashSet<Class>();
            for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
                List<ResourceWriter> forClass = (ArrayList<ResourceWriter>)ServerSerialisers.this.getWriters().get(c);
                if (forClass != null) {
                    forClass = new ArrayList<ResourceWriter>(forClass);
                    forClass.sort(new ResourceWriter.ResourceWriterComparator());
                    writers.addAll(forClass);
                }
                ArrayDeque interfaces = new ArrayDeque(Arrays.asList(c.getInterfaces()));
                while (!interfaces.isEmpty()) {
                    Class iface = (Class)interfaces.poll();
                    if (seenInterfaces.contains(iface)) continue;
                    seenInterfaces.add(iface);
                    forClass = (List)ServerSerialisers.this.getWriters().get(iface);
                    if (forClass != null) {
                        forClass = new ArrayList(forClass);
                        forClass.sort(new ResourceWriter.ResourceWriterComparator());
                        writers.addAll(forClass);
                    }
                    interfaces.addAll(Arrays.asList(iface.getInterfaces()));
                }
            }
            return writers;
        }
    };

    public static boolean invokeWriter(ResteasyReactiveRequestContext context, Object entity, MessageBodyWriter writer, ServerSerialisers serialisers) throws IOException {
        return ServerSerialisers.invokeWriter(context, entity, writer, serialisers, null);
    }

    public static boolean invokeWriter(ResteasyReactiveRequestContext context, Object entity, MessageBodyWriter writer, ServerSerialisers serialisers, MediaType mediaType) throws IOException {
        WriterInterceptor[] writerInterceptors = context.getWriterInterceptors();
        boolean outputStreamSet = context.getOutputStream() != null;
        context.serverResponse().setPreCommitListener(HEADER_FUNCTION);
        RuntimeResource target = context.getTarget();
        Type genericType = context.hasGenericReturnType() ? context.getGenericReturnType() : (target == null ? null : target.getReturnType());
        try {
            if (writer instanceof ServerMessageBodyWriter && writerInterceptors == null && !outputStreamSet) {
                ServerMessageBodyWriter quarkusRestWriter = (ServerMessageBodyWriter)writer;
                Class<?> entityClass = entity.getClass();
                if (quarkusRestWriter.isWriteable(entityClass, genericType, target == null ? null : target.getLazyMethod(), context.getResponseMediaType())) {
                    if (mediaType != null) {
                        context.setResponseContentType(mediaType);
                    }
                    quarkusRestWriter.writeResponse(entity, genericType, context);
                    return true;
                }
                return false;
            }
            if (writer.isWriteable(entity.getClass(), context.getGenericReturnType(), context.getAllAnnotations(), context.getResponseMediaType())) {
                Response response = context.getResponse().get();
                if (mediaType != null) {
                    context.setResponseContentType(mediaType);
                }
                if (writerInterceptors == null) {
                    writer.writeTo(entity, entity.getClass(), genericType, context.getAllAnnotations(), context.getResponseMediaType(), response.getHeaders(), context.getOrCreateOutputStream());
                    context.getOrCreateOutputStream().close();
                } else {
                    ServerSerialisers.runWriterInterceptors(context, entity, writer, response, writerInterceptors, serialisers);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            context.serverResponse().setPreCommitListener(null);
            context.setOutputStream(null);
            if (e instanceof RuntimeException) {
                throw new PreserveTargetException(e);
            }
            if (e instanceof IOException) {
                throw new PreserveTargetException(e);
            }
            throw new PreserveTargetException(new RuntimeException(e));
        }
    }

    public static void runWriterInterceptors(ResteasyReactiveRequestContext context, Object entity, MessageBodyWriter writer, Response response, WriterInterceptor[] writerInterceptor, ServerSerialisers serialisers) throws IOException {
        WriterInterceptorContextImpl wc = new WriterInterceptorContextImpl(context, writerInterceptor, writer, context.getAllAnnotations(), entity.getClass(), context.getGenericReturnType(), entity, response.getMediaType(), response.getHeaders(), serialisers);
        wc.proceed();
    }

    public MultivaluedMap<Class<?>, ResourceWriter> getWriters() {
        return this.writers;
    }

    public MultivaluedMap<Class<?>, ResourceReader> getReaders() {
        return this.readers;
    }

    public BestMatchingServerWriterResult findBestMatchingServerWriter(ConfigurationImpl configuration, Class<?> entityType, ServerHttpRequest request) {
        QuarkusMultivaluedHashMap writers;
        Class<?> klass = entityType;
        LinkedList toProcess = new LinkedList();
        if (configuration != null && !configuration.getResourceWriters().isEmpty()) {
            writers = new QuarkusMultivaluedHashMap();
            writers.putAll(this.writers);
            writers.addAll(configuration.getResourceWriters());
        } else {
            writers = this.writers;
        }
        BestMatchingServerWriterResult result = new BestMatchingServerWriterResult();
        do {
            if (klass == Object.class) {
                HashSet seen = new HashSet(toProcess);
                while (!toProcess.isEmpty()) {
                    Class iface = (Class)toProcess.poll();
                    List matchingWritersByType = (List)writers.get(iface);
                    this.serverResourceWriterLookup(request, matchingWritersByType, result);
                    for (Class<?> i : iface.getInterfaces()) {
                        if (seen.contains(i)) continue;
                        seen.add(i);
                        toProcess.add(i);
                    }
                }
            }
            List matchingWritersByType = (List)writers.get(klass);
            this.serverResourceWriterLookup(request, matchingWritersByType, result);
            toProcess.addAll(Arrays.asList(klass.getInterfaces()));
        } while ((klass = klass.getSuperclass()) != null);
        return result;
    }

    private void serverResourceWriterLookup(ServerHttpRequest request, List<ResourceWriter> candidates, BestMatchingServerWriterResult result) {
        if (candidates == null) {
            return;
        }
        Map.Entry<MediaType, MediaType> selectedMediaTypes = null;
        ArrayList<ResourceWriter> selectedResourceWriters = null;
        for (ResourceWriter resourceWriter : candidates) {
            Map.Entry<MediaType, MediaType> current;
            if (!resourceWriter.matchesRuntimeType(RuntimeType.SERVER) || (current = resourceWriter.serverMediaType().negotiateProduces(request.getRequestHeader("Accept"), null)).getValue() == null) continue;
            if (selectedMediaTypes == null) {
                selectedMediaTypes = current;
                selectedResourceWriters = new ArrayList<ResourceWriter>(1);
                selectedResourceWriters.add(resourceWriter);
                continue;
            }
            int compare = MediaTypeHelper.Q_COMPARATOR.compare(current.getValue(), selectedMediaTypes.getValue());
            if (compare == 0) {
                selectedResourceWriters.add(resourceWriter);
                continue;
            }
            if (compare >= 0) continue;
            selectedMediaTypes = current;
            selectedResourceWriters = new ArrayList(1);
            selectedResourceWriters.add(resourceWriter);
        }
        if (selectedMediaTypes != null) {
            for (ResourceWriter selectedResourceWriter : selectedResourceWriters) {
                result.add(selectedResourceWriter.instance(), (MediaType)selectedMediaTypes.getKey());
            }
        }
    }

    public NoMediaTypeResult findWriterNoMediaType(ResteasyReactiveRequestContext requestContext, Object entity, ServerSerialisers serialisers, RuntimeType runtimeType) {
        ResourceWriter writer;
        List<ResourceWriter> resultForClass = this.noMediaTypeClassCache.computeIfAbsent(entity.getClass(), this.mappingFunction);
        ArrayList<ResourceWriter> constrainedResultsForClass = new ArrayList<ResourceWriter>(resultForClass.size());
        for (ResourceWriter resourceWriter : resultForClass) {
            if (!resourceWriter.matchesRuntimeType(runtimeType)) continue;
            constrainedResultsForClass.add(resourceWriter);
        }
        MediaType selected = null;
        Iterator iterator = constrainedResultsForClass.iterator();
        while (iterator.hasNext() && (selected = (writer = (ResourceWriter)iterator.next()).serverMediaType().negotiateProduces(requestContext.serverRequest().getRequestHeader("Accept")).getKey()) == null) {
        }
        if (selected == null) {
            HashSet<MediaType> hashSet = new HashSet<MediaType>();
            for (ResourceWriter resourceWriter : constrainedResultsForClass) {
                hashSet.addAll(resourceWriter.mediaTypes());
            }
            throw new WebApplicationException(Response.notAcceptable(Variant.mediaTypes(hashSet.toArray(new MediaType[0])).build()).build());
        }
        if (selected.isWildcardType() || selected.getType().equals("application") && selected.isWildcardSubtype()) {
            selected = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        ArrayList arrayList = new ArrayList(constrainedResultsForClass.size());
        block3: for (ResourceWriter resourceWriter : constrainedResultsForClass) {
            if (resourceWriter.mediaTypes().isEmpty()) {
                arrayList.add(resourceWriter.instance());
                continue;
            }
            for (MediaType mt : resourceWriter.mediaTypes()) {
                if (!mt.isCompatible(selected)) continue;
                arrayList.add(resourceWriter.instance());
                continue block3;
            }
        }
        return new NoMediaTypeResult(arrayList.toArray(NO_WRITER), selected, serialisers);
    }

    public static void encodeResponseHeaders(ResteasyReactiveRequestContext requestContext) {
        ServerHttpResponse vertxResponse = requestContext.serverResponse();
        LazyResponse lazyResponse = requestContext.getResponse();
        if (!lazyResponse.isCreated() && lazyResponse.isPredetermined()) {
            EncodedMediaType contentType;
            if (requestContext.getResponseEntity() == null) {
                vertxResponse.setStatusCode(Response.Status.NO_CONTENT.getStatusCode());
            }
            if ((contentType = requestContext.getResponseContentType()) != null) {
                vertxResponse.setResponseHeader((CharSequence)CONTENT_TYPE, contentType.toString());
            }
            return;
        }
        Response response = requestContext.getResponse().get();
        vertxResponse.setStatusCode(response.getStatus());
        MultivaluedMap<String, Object> headers = response.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                String header = (String)entry.getKey();
                boolean useSet = ServerSerialisers.requireSingleHeader(header);
                Object o = ((List)entry.getValue()).get(0);
                if (o == null) {
                    if (useSet) {
                        vertxResponse.setResponseHeader((CharSequence)header, "");
                    } else {
                        vertxResponse.addResponseHeader(header, "");
                    }
                } else if (o instanceof CharSequence) {
                    if (useSet) {
                        vertxResponse.setResponseHeader((CharSequence)header, (CharSequence)o);
                    } else {
                        vertxResponse.addResponseHeader(header, (CharSequence)o);
                    }
                } else if (useSet) {
                    vertxResponse.setResponseHeader((CharSequence)header, HeaderUtil.headerToString(o));
                } else {
                    vertxResponse.addResponseHeader(header, HeaderUtil.headerToString(o));
                }
                if (!header.equalsIgnoreCase(TRANSFER_ENCODING)) continue;
                vertxResponse.removeResponseHeader("Content-Length");
                continue;
            }
            ArrayList<String> strValues = new ArrayList<String>(((List)entry.getValue()).size());
            for (Object o : (List)entry.getValue()) {
                strValues.add(HeaderUtil.headerToString(o));
            }
            vertxResponse.setResponseHeader((CharSequence)entry.getKey(), strValues);
        }
    }

    private static boolean requireSingleHeader(String header) {
        if (!(header.startsWith(CONTENT) || header.startsWith(CONTENT_LOWER) || header.startsWith(LOCATION) || header.equalsIgnoreCase(TRANSFER_ENCODING))) {
            return false;
        }
        if (header.length() < CONTENT.length() + 2) {
            return false;
        }
        String substring = header.substring(CONTENT.length() + 1).toLowerCase(Locale.ROOT);
        return substring.equals(TYPE_LOWER) || substring.equals(LENGTH_LOWER);
    }

    public static class BestMatchingServerWriterResult {
        final List<Entry> entries = new ArrayList<Entry>();

        void add(MessageBodyWriter<?> writer, MediaType mediaType) {
            this.entries.add(new Entry(writer, mediaType));
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public List<MessageBodyWriter<?>> getMessageBodyWriters() {
            if (this.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList(this.entries.size());
            for (Entry entry : this.entries) {
                result.add(entry.writer);
            }
            return result;
        }

        public MediaType getSelectedMediaType() {
            if (this.isEmpty()) {
                return null;
            }
            return this.entries.get((int)0).mediaType;
        }

        private static class Entry {
            final MessageBodyWriter<?> writer;
            final MediaType mediaType;

            public Entry(MessageBodyWriter<?> writer, MediaType mediaType) {
                this.writer = writer;
                this.mediaType = mediaType;
            }
        }
    }

    public static class NoMediaTypeResult {
        final MessageBodyWriter<?>[] writers;
        final MediaType mediaType;
        final EntityWriter entityWriter;

        public NoMediaTypeResult(MessageBodyWriter<?>[] writers, MediaType mediaType, ServerSerialisers serialisers) {
            this.writers = writers;
            this.mediaType = mediaType;
            this.entityWriter = new FixedEntityWriterArray(writers, serialisers);
        }

        public MessageBodyWriter<?>[] getWriters() {
            return this.writers;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public EntityWriter getEntityWriter() {
            return this.entityWriter;
        }
    }
}

