/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.jboss.resteasy.reactive.server.multipart.FormValue;

public class DefaultFileUpload
implements FileUpload {
    private final String name;
    private final FormValue fileUpload;

    public DefaultFileUpload(String name, FormValue fileUpload) {
        this.name = name;
        this.fileUpload = fileUpload;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Path filePath() {
        return this.fileUpload.getFileItem().getFile();
    }

    @Override
    public String fileName() {
        return this.fileUpload.getFileName();
    }

    @Override
    public long size() {
        try {
            return this.fileUpload.getFileItem().getFileSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String contentType() {
        return this.fileUpload.getHeaders().getFirst("Content-Type");
    }

    @Override
    public String charSet() {
        String ct = this.fileUpload.getHeaders().getFirst("Content-Type");
        if (ct == null) {
            return null;
        }
        return HeaderUtil.extractQuotedValueFromHeader(ct, "charset");
    }
}

