/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters;

import jakarta.ws.rs.core.MediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.DefaultFileUpload;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartSupport;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;

public class MultipartFormParamExtractor
implements ParameterExtractor {
    private final String name;
    private final String mimeType;
    private final Type type;
    private final boolean single;
    private final java.lang.reflect.Type genericType;
    private final Class<Object> typeClass;
    private final boolean encoded;

    public MultipartFormParamExtractor(String name, boolean single, Type type, Class<Object> typeClass, java.lang.reflect.Type genericType, String mimeType, boolean encoded) {
        this.name = name;
        this.single = single;
        this.type = type;
        this.mimeType = mimeType;
        this.typeClass = typeClass;
        this.genericType = genericType;
        this.encoded = encoded;
    }

    @Override
    public Object extractParameter(ResteasyReactiveRequestContext context) {
        switch (this.type) {
            case String: {
                if (this.single) {
                    return MultipartSupport.getString(this.name, context, this.encoded);
                }
                return MultipartSupport.getStrings(this.name, context, this.encoded);
            }
            case ByteArray: {
                if (this.single) {
                    return MultipartSupport.getByteArray(this.name, context);
                }
                return MultipartSupport.getByteArrays(this.name, context);
            }
            case InputStream: {
                if (this.single) {
                    return MultipartSupport.getInputStream(this.name, context);
                }
                return MultipartSupport.getInputStreams(this.name, context);
            }
            case PartType: {
                if (this.single) {
                    return MultipartSupport.getConvertedFormAttribute(this.name, this.typeClass, this.genericType, MediaType.valueOf(this.mimeType), context);
                }
                return MultipartSupport.getConvertedFormAttributes(this.name, this.typeClass, this.genericType, MediaType.valueOf(this.mimeType), context);
            }
            case FileUpload: {
                if (this.name.equals("*")) {
                    return MultipartSupport.getFileUploads(context);
                }
                return this.single ? MultipartSupport.getFileUpload(this.name, context) : MultipartSupport.getFileUploads(this.name, context);
            }
            case File: {
                if (this.single) {
                    DefaultFileUpload upload = MultipartSupport.getFileUpload(this.name, context);
                    return upload != null ? upload.uploadedFile().toFile() : null;
                }
                return MultipartSupport.getJavaIOFileUploads(this.name, context);
            }
            case Path: {
                if (this.single) {
                    DefaultFileUpload upload = MultipartSupport.getFileUpload(this.name, context);
                    return upload != null ? upload.uploadedFile() : null;
                }
                return MultipartSupport.getJavaPathFileUploads(this.name, context);
            }
        }
        throw new RuntimeException("Unknown multipart parameter type: " + String.valueOf((Object)this.type) + " for parameter " + this.name);
    }

    public static enum Type {
        FileUpload,
        File,
        Path,
        PartType,
        String,
        ByteArray,
        InputStream;

    }
}

