/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.reflection;

import jakarta.inject.Inject;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.parameters.ContextParamExtractor;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ReflectiveContextInjectedBeanFactory<T>
implements BeanFactory<T> {
    public static final Function<Class<?>, BeanFactory<?>> FACTORY = new Function<Class<?>, BeanFactory<?>>(){

        @Override
        public BeanFactory<?> apply(Class<?> clazz) {
            return ReflectiveContextInjectedBeanFactory.create(clazz);
        }
    };
    public static final Function<String, BeanFactory<?>> STRING_FACTORY = new Function<String, BeanFactory<?>>(){

        @Override
        public BeanFactory<?> apply(String name) {
            try {
                return FACTORY.apply(Thread.currentThread().getContextClassLoader().loadClass(name));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Constructor<T> constructor;
    private final Map<Field, Supplier<Object>> proxiesToInject;
    private final List<Supplier<Object>> constructorParams;

    public static <T> BeanFactory<T> create(final Class<?> clazz) {
        Constructor<?>[] declaredConstructors;
        Constructor<?> ctor = null;
        for (Constructor<?> i : declaredConstructors = clazz.getDeclaredConstructors()) {
            if (!i.isAnnotationPresent(Inject.class) && declaredConstructors.length != 1) continue;
            ctor = i;
        }
        if (ctor == null) {
            try {
                ctor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return new BeanFactory<T>(){

                    @Override
                    public BeanFactory.BeanInstance<T> createInstance() {
                        throw new RuntimeException("Unable to create " + String.valueOf(clazz), e);
                    }
                };
            }
        }
        ctor.setAccessible(true);
        return new ReflectiveContextInjectedBeanFactory(ctor);
    }

    public static <T> BeanFactory<T> create(String name) {
        return STRING_FACTORY.apply(name);
    }

    public ReflectiveContextInjectedBeanFactory(Constructor<T> constructor) {
        this.constructor = constructor;
        constructor.setAccessible(true);
        this.constructorParams = new ArrayList<Supplier<Object>>();
        for (Class<?> i : constructor.getParameterTypes()) {
            Annotation param;
            if (i.isInterface() && (i.getName().startsWith("jakarta.ws.rs") || i.getName().startsWith("jakarta.ws.rs"))) {
                Object val = this.extractContextParam(i);
                this.constructorParams.add(() -> val);
                continue;
            }
            if (i.isAnnotationPresent(QueryParam.class)) {
                param = i.getAnnotation(QueryParam.class);
                this.constructorParams.add(() -> ReflectiveContextInjectedBeanFactory.lambda$new$1((QueryParam)param));
                continue;
            }
            if (i.isAnnotationPresent(HeaderParam.class)) {
                param = i.getAnnotation(HeaderParam.class);
                this.constructorParams.add(() -> ReflectiveContextInjectedBeanFactory.lambda$new$2((HeaderParam)param));
                continue;
            }
            BeanFactory factory = ReflectiveContextInjectedBeanFactory.create(i);
            this.constructorParams.add(() -> factory.createInstance().getInstance());
        }
        this.proxiesToInject = new HashMap<Field, Supplier<Object>>();
        for (Class<T> c = constructor.getDeclaringClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                if (f.isAnnotationPresent(Context.class)) {
                    f.setAccessible(true);
                    Object contextParam = this.extractContextParam(f.getType());
                    this.proxiesToInject.put(f, () -> contextParam);
                    continue;
                }
                if (!f.isAnnotationPresent(Inject.class)) continue;
                f.setAccessible(true);
                BeanFactory factory = ReflectiveContextInjectedBeanFactory.create(f.getType());
                this.proxiesToInject.put(f, () -> {
                    try {
                        return factory.createInstance().getInstance();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to inject field " + String.valueOf(f), t);
                    }
                });
            }
        }
    }

    private Object extractContextParam(Class<?> type) {
        final ContextParamExtractor contextParamExtractor = new ContextParamExtractor(type);
        Object contextParam = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object delegate = contextParamExtractor.extractParameter(CurrentRequestManager.get());
                return method.invoke(delegate, args);
            }
        });
        return contextParam;
    }

    @Override
    public BeanFactory.BeanInstance<T> createInstance() {
        try {
            Object[] params = new Object[this.constructorParams.size()];
            for (int i = 0; i < this.constructorParams.size(); ++i) {
                params[i] = this.constructorParams.get(i).get();
            }
            final T instance = this.constructor.newInstance(params);
            for (Map.Entry<Field, Supplier<Object>> i : this.proxiesToInject.entrySet()) {
                i.getKey().set(instance, i.getValue().get());
            }
            return new BeanFactory.BeanInstance<T>(){

                @Override
                public T getInstance() {
                    return instance;
                }

                @Override
                public void close() {
                }
            };
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ Object lambda$new$2(HeaderParam param) {
        return CurrentRequestManager.get().getHeader(param.value(), true);
    }

    private static /* synthetic */ Object lambda$new$1(QueryParam param) {
        return CurrentRequestManager.get().getQueryParameter(param.value(), true, false);
    }
}

