/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.util.List;
import java.util.Locale;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class FixedProducesHandler
implements ServerRestHandler {
    final EncodedMediaType mediaType;
    final String mediaTypeString;
    final String mediaTypeSubstring;
    final EntityWriter writer;

    public FixedProducesHandler(MediaType mediaType, EntityWriter writer) {
        this.mediaType = new EncodedMediaType(mediaType);
        this.writer = writer;
        this.mediaTypeString = new StringBuilder(mediaType.getType().length() + 1 + mediaType.getSubtype().length()).append(mediaType.getType()).append("/").append(mediaType.getSubtype()).toString();
        this.mediaTypeSubstring = new StringBuilder(mediaType.getType().length() + 2).append(mediaType.getType()).append("/*").toString();
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        List acceptValues;
        if (requestContext.isProducesChecked() || (acceptValues = (List)requestContext.getHeader("Accept", false)).isEmpty()) {
            requestContext.setResponseContentType(this.mediaType);
            requestContext.setEntityWriter(this.writer);
        } else {
            boolean handled = false;
            for (int i = 0; i < acceptValues.size(); ++i) {
                String accept = (String)acceptValues.get(i);
                if (accept.contains(this.mediaTypeString) || accept.contains("*/*") || accept.contains(this.mediaTypeSubstring)) {
                    requestContext.setResponseContentType(this.mediaType);
                    requestContext.setEntityWriter(this.writer);
                    handled = true;
                    break;
                }
                String lowercaseAccept = accept.toLowerCase(Locale.ROOT);
                if (!lowercaseAccept.contains(this.mediaTypeString) && !lowercaseAccept.contains(this.mediaTypeSubstring)) continue;
                requestContext.setResponseContentType(this.mediaType);
                requestContext.setEntityWriter(this.writer);
                handled = true;
                break;
            }
            if (!handled) {
                throw new WebApplicationException(Response.notAcceptable(Variant.mediaTypes(this.mediaType.getMediaType()).build()).build());
            }
        }
    }
}

