/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;

public class ContainerResponseContextImpl
implements ContainerResponseContext {
    private final ResteasyReactiveRequestContext context;

    public ContainerResponseContextImpl(ResteasyReactiveRequestContext requestContext) {
        this.context = requestContext;
    }

    @Override
    public int getStatus() {
        return this.response().getStatus();
    }

    protected Response response() {
        return this.context.getResponse().get();
    }

    @Override
    public void setStatus(int code) {
        this.context.setResult(Response.fromResponse(this.response()).status(code).build());
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.response().getStatusInfo();
    }

    @Override
    public void setStatusInfo(Response.StatusType statusInfo) {
        this.context.setResult(Response.fromResponse(this.response()).status(statusInfo).build());
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.response().getHeaders();
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        return this.response().getStringHeaders();
    }

    @Override
    public String getHeaderString(String name) {
        return this.response().getHeaderString(name);
    }

    @Override
    public Set<String> getAllowedMethods() {
        return this.response().getAllowedMethods();
    }

    @Override
    public Date getDate() {
        return this.response().getDate();
    }

    @Override
    public Locale getLanguage() {
        return this.response().getLanguage();
    }

    @Override
    public int getLength() {
        return this.response().getLength();
    }

    @Override
    public MediaType getMediaType() {
        return this.response().getMediaType();
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return this.response().getCookies();
    }

    @Override
    public EntityTag getEntityTag() {
        return this.response().getEntityTag();
    }

    @Override
    public Date getLastModified() {
        return this.response().getLastModified();
    }

    @Override
    public URI getLocation() {
        return this.response().getLocation();
    }

    @Override
    public Set<Link> getLinks() {
        return this.response().getLinks();
    }

    @Override
    public boolean hasLink(String relation) {
        return this.response().hasLink(relation);
    }

    @Override
    public Link getLink(String relation) {
        return this.response().getLink(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        return this.response().getLinkBuilder(relation);
    }

    @Override
    public boolean hasEntity() {
        return this.response().hasEntity();
    }

    @Override
    public Object getEntity() {
        return this.response().getEntity();
    }

    @Override
    public Class<?> getEntityClass() {
        Object entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getClass();
    }

    @Override
    public Type getEntityType() {
        return this.context.getGenericReturnType();
    }

    @Override
    public void setEntity(Object entity) {
        this.context.resetBuildTimeSerialization();
        if (entity instanceof GenericEntity) {
            this.context.setGenericReturnType(((GenericEntity)entity).getType());
            entity = ((GenericEntity)entity).getEntity();
        }
        Response.ResponseBuilder resp = Response.fromResponse(this.response()).entity(entity);
        this.context.setResult(resp.build());
    }

    @Override
    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.context.resetBuildTimeSerialization();
        if (entity instanceof GenericEntity) {
            this.context.setGenericReturnType(((GenericEntity)entity).getType());
            entity = ((GenericEntity)entity).getEntity();
        }
        this.context.setResponseContentType(mediaType);
        this.context.setAllAnnotations(annotations);
        Response.ResponseBuilder resp = Response.fromResponse(this.response()).entity(entity).type(mediaType);
        this.context.setResult(resp.build());
    }

    @Override
    public Annotation[] getEntityAnnotations() {
        return this.context.getAllAnnotations();
    }

    @Override
    public OutputStream getEntityStream() {
        OutputStream existing = this.context.getOutputStream();
        if (existing != null) {
            return existing;
        }
        return this.context.getOrCreateOutputStream();
    }

    @Override
    public void setEntityStream(OutputStream outputStream) {
        this.context.setOutputStream(outputStream);
    }
}

