/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.server.jaxrs.FeatureContextImpl;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class DynamicFeatureContext
extends FeatureContextImpl {
    public DynamicFeatureContext(ResourceInterceptors interceptors, ConfigurationImpl configuration, Function<Class<?>, BeanFactory<?>> beanContainer) {
        super(interceptors, null, configuration, beanContainer);
    }

    @Override
    protected boolean isAllowed(Class<?> componentClass) {
        return this.isFilter(componentClass) || this.isInterceptor(componentClass);
    }

    @Override
    protected void registerFilters(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority) {
        boolean isRequest = ContainerRequestFilter.class.isAssignableFrom(componentClass);
        boolean isResponse = ContainerResponseFilter.class.isAssignableFrom(componentClass);
        if (isRequest) {
            this.register(componentClass, beanFactory, priority, this.interceptors.getContainerRequestFilters());
        }
        if (isResponse) {
            this.register(componentClass, beanFactory, priority, this.interceptors.getContainerResponseFilters());
        }
    }

    private <T> void register(Class<?> componentClass, BeanFactory<?> beanFactory, Integer priority, InterceptorContainer<T> interceptors) {
        ResourceInterceptor<T> responseInterceptor = interceptors.create();
        this.setFilterPriority(componentClass, priority, responseInterceptor);
        responseInterceptor.setFactory(this.getFactory(componentClass, beanFactory));
        interceptors.addGlobalRequestInterceptor(responseInterceptor);
    }
}

