/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.UnmodifiableMultivaluedMap;

public class HttpHeadersImpl
implements HttpHeaders {
    private final MultivaluedMap<String, String> requestHeaders = new CaseInsensitiveMap<String>();
    private final MultivaluedMap<String, String> unmodifiableRequestHeaders;
    private String cachedMediaTypeString;
    private MediaType cachedMediaType;

    public HttpHeadersImpl(Iterable<Map.Entry<String, String>> vertxHeaders) {
        for (Map.Entry<String, String> entry : vertxHeaders) {
            this.requestHeaders.add(entry.getKey(), entry.getValue());
        }
        this.unmodifiableRequestHeaders = new UnmodifiableMultivaluedMap<String, String>(this.requestHeaders, false);
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.unmodifiableRequestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    @Override
    public List<String> getRequestHeader(String name) {
        List vals = (List)this.unmodifiableRequestHeaders.get(name);
        return vals == null ? Collections.emptyList() : vals;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return Collections.unmodifiableMap(HeaderUtil.getCookies(this.requestHeaders));
    }

    @Override
    public Date getDate() {
        return HeaderUtil.getDate(this.requestHeaders);
    }

    @Override
    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString(this.requestHeaders, name);
    }

    @Override
    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.requestHeaders);
    }

    @Override
    public int getLength() {
        return HeaderUtil.getLength(this.requestHeaders);
    }

    @Override
    public MediaType getMediaType() {
        String obj = this.requestHeaders.getFirst("Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj == this.cachedMediaTypeString) {
            return this.cachedMediaType;
        }
        this.cachedMediaTypeString = obj;
        this.cachedMediaType = MediaTypeHelper.valueOf(obj);
        return this.cachedMediaType;
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        List<MediaType> modifiableAcceptableMediaTypes = this.getModifiableAcceptableMediaTypes();
        if (modifiableAcceptableMediaTypes.size() > 1) {
            return Collections.unmodifiableList(modifiableAcceptableMediaTypes);
        }
        return modifiableAcceptableMediaTypes;
    }

    public List<MediaType> getModifiableAcceptableMediaTypes() {
        return HeaderUtil.getAcceptableMediaTypes(this.requestHeaders);
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        return HeaderUtil.getAcceptableLanguages(this.requestHeaders);
    }
}

