/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.resteasy.reactive.common.jaxrs.AbstractResponseBuilder;
import org.jboss.resteasy.reactive.common.util.DateUtil;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.request.ServerDrivenNegotiation;

public class RequestImpl
implements Request {
    private final ResteasyReactiveRequestContext requestContext;
    private final String httpMethod;
    private String varyHeader;

    public RequestImpl(ResteasyReactiveRequestContext requestContext) {
        this.requestContext = requestContext;
        this.httpMethod = requestContext.serverRequest().getRequestMethod();
    }

    @Override
    public String getMethod() {
        return this.requestContext.serverRequest().getRequestMethod();
    }

    private boolean isRfc7232preconditions() {
        return true;
    }

    @Override
    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.size() == 0) {
            throw new IllegalArgumentException("Variant list must not be empty");
        }
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        MultivaluedMap<String, String> requestHeaders = this.requestContext.getHttpHeaders().getRequestHeaders();
        negotiation.setAcceptHeaders((List)requestHeaders.get("Accept"));
        negotiation.setAcceptCharsetHeaders((List)requestHeaders.get("Accept-Charset"));
        negotiation.setAcceptEncodingHeaders((List)requestHeaders.get("Accept-Encoding"));
        negotiation.setAcceptLanguageHeaders((List)requestHeaders.get("Accept-Language"));
        this.varyHeader = AbstractResponseBuilder.createVaryHeader(variants);
        this.requestContext.serverResponse().setResponseHeader((CharSequence)"Vary", this.varyHeader);
        return negotiation.getBestMatch(variants);
    }

    private List<EntityTag> convertEtag(List<String> tags) {
        ArrayList<EntityTag> result = new ArrayList<EntityTag>();
        for (String tag : tags) {
            String[] split;
            for (String etag : split = tag.split(",")) {
                result.add(EntityTag.valueOf(etag.trim()));
            }
        }
        return result;
    }

    private Response.ResponseBuilder ifMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals(eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            return null;
        }
        return Response.status(Response.Status.PRECONDITION_FAILED).tag(eTag);
    }

    private Response.ResponseBuilder ifNoneMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals(eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            if ("GET".equals(this.httpMethod) || "HEAD".equals(this.httpMethod)) {
                return Response.notModified(eTag);
            }
            return Response.status(Response.Status.PRECONDITION_FAILED).tag(eTag);
        }
        return null;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        List ifNoneMatch;
        if (eTag == null) {
            throw new IllegalArgumentException("ETag was null");
        }
        Response.ResponseBuilder builder = null;
        List ifMatch = (List)this.requestContext.getHttpHeaders().getRequestHeaders().get("If-Match");
        if (ifMatch != null && ifMatch.size() > 0) {
            builder = this.ifMatch(this.convertEtag(ifMatch), eTag);
        }
        if (builder == null && (ifNoneMatch = (List)this.requestContext.getHttpHeaders().getRequestHeaders().get("If-None-Match")) != null && ifNoneMatch.size() > 0) {
            builder = this.ifNoneMatch(this.convertEtag(ifNoneMatch), eTag);
        }
        if (builder != null) {
            builder.tag(eTag);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", this.varyHeader);
        }
        return builder;
    }

    private Response.ResponseBuilder ifModifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate(strDate);
        if (date.getTime() >= this.millisecondsWithSecondsPrecision(lastModified)) {
            return Response.notModified();
        }
        return null;
    }

    private Response.ResponseBuilder ifUnmodifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate(strDate);
        if (date.getTime() >= this.millisecondsWithSecondsPrecision(lastModified)) {
            return null;
        }
        return Response.status(Response.Status.PRECONDITION_FAILED).lastModified(lastModified);
    }

    private long millisecondsWithSecondsPrecision(Date lastModified) {
        return lastModified.getTime() / 1000L * 1000L;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifUnmodifiedSince;
        if (lastModified == null) {
            throw new IllegalArgumentException("Param cannot be null");
        }
        Response.ResponseBuilder builder = null;
        MultivaluedMap<String, String> headers = this.requestContext.getHttpHeaders().getRequestHeaders();
        String ifModifiedSince = headers.getFirst("If-Modified-Since");
        if (!(ifModifiedSince == null || this.isRfc7232preconditions() && headers.containsKey("If-None-Match"))) {
            builder = this.ifModifiedSince(ifModifiedSince, lastModified);
        }
        if (!(builder != null || (ifUnmodifiedSince = headers.getFirst("If-Unmodified-Since")) == null || this.isRfc7232preconditions() && headers.containsKey("If-Match"))) {
            builder = this.ifUnmodifiedSince(ifUnmodifiedSince, lastModified);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", this.varyHeader);
        }
        return builder;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException("Last modified was null");
        }
        if (eTag == null) {
            throw new IllegalArgumentException("etag was null");
        }
        Response.ResponseBuilder rtn = null;
        Response.ResponseBuilder lastModifiedBuilder = this.evaluatePreconditions(lastModified);
        Response.ResponseBuilder etagBuilder = this.evaluatePreconditions(eTag);
        if (lastModifiedBuilder == null && etagBuilder == null) {
            rtn = null;
        } else if (lastModifiedBuilder != null && etagBuilder == null) {
            rtn = lastModifiedBuilder;
        } else if (lastModifiedBuilder == null && etagBuilder != null) {
            rtn = etagBuilder;
        } else {
            rtn = lastModifiedBuilder;
            rtn.tag(eTag);
        }
        if (rtn != null && this.varyHeader != null) {
            rtn.header("Vary", this.varyHeader);
        }
        return rtn;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatch = (List)this.requestContext.getHttpHeaders().getRequestHeaders().get("If-Match");
        if (ifMatch == null || ifMatch.size() == 0) {
            return null;
        }
        return Response.status(Response.Status.PRECONDITION_FAILED);
    }
}

