/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.jaxrs.UriBuilderImpl;
import org.jboss.resteasy.reactive.common.util.PathSegmentImpl;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.URIDecoder;
import org.jboss.resteasy.reactive.common.util.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.UriMatch;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

public class UriInfoImpl
implements UriInfo {
    private final ResteasyReactiveRequestContext currentRequest;
    private MultivaluedMap<String, String> queryParams;
    private MultivaluedMap<String, String> pathParams;
    private URI requestUri;

    public UriInfoImpl(ResteasyReactiveRequestContext currentRequest) {
        this.currentRequest = currentRequest;
    }

    @Override
    public String getPath() {
        return this.getPath(true);
    }

    @Override
    public String getPath(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        String path = URIDecoder.decodeURIComponent(this.currentRequest.getPath(), false);
        String prefix = this.currentRequest.getDeployment().getPrefix();
        if (prefix.isEmpty()) {
            return path;
        }
        if (path.length() == prefix.length()) {
            return "/";
        }
        return path.substring(prefix.length());
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        return PathSegmentImpl.parseSegments(this.getPath(), decode);
    }

    @Override
    public URI getRequestUri() {
        if (this.requestUri == null) {
            ServerHttpRequest request = this.currentRequest.serverRequest();
            try {
                this.requestUri = new URI(this.currentRequest.getAbsoluteURI()).normalize();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.requestUri;
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri(this.getRequestUri());
    }

    @Override
    public URI getAbsolutePath() {
        try {
            String effectiveURI = this.currentRequest.getAbsoluteURI();
            int queryParamsIndex = effectiveURI.indexOf(63);
            if (queryParamsIndex > 0) {
                effectiveURI = effectiveURI.substring(0, queryParamsIndex);
            }
            return new URI(effectiveURI).normalize();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri(this.getAbsolutePath());
    }

    @Override
    public URI getBaseUri() {
        try {
            Deployment deployment = this.currentRequest.getDeployment();
            Object prefix = "/";
            if (deployment != null) {
                prefix = deployment.getPrefix();
                prefix = ((String)prefix).isEmpty() ? "/" : (String)prefix + "/";
            }
            return new URI(this.currentRequest.getScheme(), this.currentRequest.getAuthority(), (String)prefix, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri(this.getBaseUri());
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        if (this.pathParams == null) {
            this.pathParams = new QuarkusMultivaluedHashMap<String, String>();
            RuntimeResource target = this.currentRequest.getTarget();
            if (target != null) {
                for (Map.Entry<String, Integer> pathParam : target.getPathParameterIndexes().entrySet()) {
                    this.pathParams.add(pathParam.getKey(), this.currentRequest.getPathParam(pathParam.getValue(), false));
                }
            }
        }
        return new UnmodifiableMultivaluedMap<String, String>(this.pathParams);
    }

    private RuntimeException encodedNotSupported() {
        return new IllegalArgumentException("We do not support non-decoded parameters");
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        if (this.queryParams == null) {
            this.queryParams = new QuarkusMultivaluedHashMap<String, String>();
            Collection<String> entries = this.currentRequest.serverRequest().queryParamNames();
            for (String i : entries) {
                this.queryParams.addAll(i, this.currentRequest.serverRequest().getAllQueryParams(i));
            }
        }
        return new UnmodifiableMultivaluedMap<String, String>(this.queryParams);
    }

    @Override
    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        if (!decode) {
            throw this.encodedNotSupported();
        }
        if (this.currentRequest.getTarget() == null) {
            return Collections.emptyList();
        }
        List<UriMatch> oldMatches = this.currentRequest.getMatchedURIs();
        ArrayList<String> matched = new ArrayList<String>();
        String last = null;
        for (int i = 0; i < oldMatches.size(); ++i) {
            String m = oldMatches.get((int)i).matched;
            if (m.equals(last)) continue;
            matched.add(m);
            last = m;
        }
        return matched;
    }

    @Override
    public List<Object> getMatchedResources() {
        List<UriMatch> oldMatches = this.currentRequest.getMatchedURIs();
        ArrayList<Object> matched = new ArrayList<Object>();
        for (int i = 0; i < oldMatches.size(); ++i) {
            Object target = oldMatches.get((int)i).target;
            if (target == null) continue;
            matched.add(target);
        }
        return matched;
    }

    @Override
    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    @Override
    public URI relativize(URI uri) {
        URI from = this.getRequestUri();
        URI to = uri;
        if (uri.getScheme() == null && uri.getHost() == null) {
            to = this.getBaseUriBuilder().replaceQuery(null).path(uri.getPath()).replaceQuery(uri.getQuery()).fragment(uri.getFragment()).build(new Object[0]);
        }
        return UriBuilderImpl.relativize(from, to);
    }
}

