/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mcp;

import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.wildfly.mcp.Server;
import org.wildfly.mcp.User;

public class JMXSession
implements AutoCloseable {
    private final JMXConnector jmxConnector;
    public final MBeanServerConnection connection;

    public JMXSession(Server server, User user) throws Exception {
        String urlString = "service:jmx:remote+http://" + server.host + ":" + server.port;
        JMXServiceURL serviceURL = new JMXServiceURL(urlString);
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        if (user.userName != null && user.userPassword != null) {
            environment.put("jmx.remote.credentials", new String[]{user.userName, user.userPassword});
        }
        this.jmxConnector = JMXConnectorFactory.connect(serviceURL, environment);
        this.connection = this.jmxConnector.getMBeanServerConnection();
    }

    @Override
    public void close() throws Exception {
        this.jmxConnector.close();
    }
}

