/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mcp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.ws.rs.ForbiddenException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.dmr.ModelNode;
import org.wildfly.mcp.Server;
import org.wildfly.mcp.User;
import org.wildfly.mcp.WildFlyStatus;

public class WildFlyManagementClient {
    static Logger LOGGER = Logger.getLogger("org.wildfly.mcp.WildFlyManagementClient");

    public <T extends ManagementResponse> T call(ManagementRequest<T> request) throws Exception {
        return request.getResponse(this.call(request.server, request.user, request.toJson(), request.stream));
    }

    public String call(Server server, User user, ParsedCommandLine parsedLine) throws Exception {
        return this.call(server, user, WildFlyManagementClient.toJSON(parsedLine), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String call(Server server, User user, String json, boolean stream) throws Exception {
        HttpClientBuilder builder = HttpClients.custom();
        if (user != null && user.userName != null && user.userPassword != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(server.host, Integer.parseInt(server.port), "ManagementRealm", "digest"), new UsernamePasswordCredentials(user.userName, user.userPassword));
            builder.setDefaultCredentialsProvider(credsProvider);
        }
        try (CloseableHttpClient httpclient = builder.build();){
            String string;
            HttpPost httppost = new HttpPost("http://" + server.host + ":" + server.port + "/management" + (stream ? "/?useStreamAsResponse" : ""));
            StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httppost.setEntity(requestEntity);
            LOGGER.info("Executing request " + String.valueOf(httppost.getRequestLine()));
            CloseableHttpResponse response = httpclient.execute(httppost);
            try {
                int code = response.getStatusLine().getStatusCode();
                if (this.isAuthenticationError(code)) {
                    throw new AuthenticationException("Authentication error, could you check the provided username and password.");
                }
                if (this.isForbiddenError(code)) {
                    throw new ForbiddenException("Authentication error, the provided user is not allowed to interact with the server.");
                }
                LOGGER.info("----------------------------------------");
                LOGGER.info(response.getStatusLine().toString());
                String reply = EntityUtils.toString(response.getEntity());
                LOGGER.info(reply);
                string = reply;
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
    }

    public static String toJSON(ParsedCommandLine parsedLine) throws CommandFormatException {
        if (parsedLine.getFormat() != OperationFormat.INSTANCE) {
            throw new OperationFormatException("The line does not follow the operation request format");
        }
        ModelNode request = new ModelNode();
        ModelNode addressNode = request.get("address");
        if (parsedLine.getAddress().isEmpty()) {
            addressNode.setEmptyList();
        } else {
            Iterator iterator = parsedLine.getAddress().iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    addressNode.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("The node name is not specified for type '" + node.getType() + "'");
            }
        }
        String operationName = parsedLine.getOperationName();
        if (operationName == null || operationName.isEmpty()) {
            throw new OperationFormatException("The operation name is missing or the format of the operation request is wrong.");
        }
        request.get("operation").set(operationName);
        for (String propName : parsedLine.getPropertyNames()) {
            String value = parsedLine.getPropertyValue(propName);
            if (propName == null || propName.trim().isEmpty()) {
                throw new OperationFormatException("The argument name is not specified: '" + propName + "'");
            }
            if (value == null || value.trim().isEmpty()) {
                throw new OperationFormatException("The argument value is not specified for " + propName + ": '" + value + "'");
            }
            ModelNode toSet = ModelNode.fromString(value);
            request.get(propName).set(toSet);
        }
        return request.toJSONString(false);
    }

    public WildFlyStatus getStatus(Server server, User user) throws Exception {
        String serverState = this.call(new ReadServerStateRequest((Server)server, (User)user)).result;
        String runningMode = this.call(new ReadRunningModeRequest((Server)server, (User)user)).result;
        List<Deployment> deployments = this.call(new ReadDeploymentsStatusRequest((Server)server, (User)user)).result;
        List<Object> bootErrors = this.call(new ReadBootErrorsRequest((Server)server, (User)user)).result;
        return new WildFlyStatus(serverState, runningMode, bootErrors, deployments);
    }

    private boolean isAuthenticationError(int code) {
        return code == 401;
    }

    private boolean isForbiddenError(int code) {
        return code == 403;
    }

    public static abstract class ManagementRequest<R extends ManagementResponse> {
        public final List<String> address = new ArrayList<String>();
        public final String operation;
        private final Server server;
        private final User user;
        private final Class<R> responseClass;
        private final boolean stream;

        protected ManagementRequest(Class<R> responseClass, String operation, Server server, User user) {
            this(responseClass, operation, server, user, false);
        }

        protected ManagementRequest(Class<R> responseClass, String operation, Server server, User user, boolean stream) {
            this.responseClass = responseClass;
            this.operation = operation;
            this.server = server;
            this.user = user;
            this.stream = stream;
        }

        String toJson() throws JsonProcessingException {
            ObjectWriter ow = new ObjectMapper().writer();
            return ow.writeValueAsString(this);
        }

        R getResponse(String json) throws JsonProcessingException {
            return (R)((ManagementResponse)new ObjectMapper().readValue(json, this.responseClass));
        }
    }

    public static class ManagementResponse {
        public String outcome;
        @JsonProperty(value="failure-description")
        public String failureDescription;
        @JsonProperty(value="response-headers")
        Map<String, Object> responseHeaders;
    }

    public static class ReadServerStateRequest
    extends ReadAttributeRequest<ReadAttributeResponse> {
        ReadServerStateRequest(Server server, User user) {
            super(ReadAttributeResponse.class, server, user, "server-state");
        }
    }

    public static class ReadAttributeResponse
    extends ManagementResponse {
        public String result;
    }

    public static class ReadRunningModeRequest
    extends ReadAttributeRequest<ReadAttributeResponse> {
        ReadRunningModeRequest(Server server, User user) {
            super(ReadAttributeResponse.class, server, user, "running-mode");
        }
    }

    public static class ReadDeploymentsStatusRequest
    extends ReadAttributeRequest<ReadDeploymentsStatusResponse> {
        ReadDeploymentsStatusRequest(Server server, User user) {
            super(ReadDeploymentsStatusResponse.class, server, user, "status");
            this.address.add("deployment");
            this.address.add("*");
        }
    }

    public static class ReadDeploymentsStatusResponse
    extends ReadAttributeResponse {
        public List<Deployment> result;
    }

    public static class ReadBootErrorsRequest
    extends ManagementRequest<ReadBootErrorsResponse> {
        ReadBootErrorsRequest(Server server, User user) {
            super(ReadBootErrorsResponse.class, "read-boot-errors", server, user);
            this.address.add("core-service");
            this.address.add("management");
        }
    }

    public static class ReadBootErrorsResponse
    extends ManagementResponse {
        public List<Object> result;
    }

    public static class ReadConfigAsXmlResponse
    extends ManagementResponse {
        public String result;
    }

    public static class GetLoggingFileResponse
    extends ManagementResponse {
        public List<String> result;
    }

    public static class GetLoggersResponse
    extends ManagementResponse {
        public Set<String> result;
    }

    public static class RemoveLoggerRequest
    extends ManagementRequest<ManagementResponse> {
        RemoveLoggerRequest(Server server, User user, String category) {
            super(ManagementResponse.class, "remove", server, user);
            this.address.add("subsystem");
            this.address.add("logging");
            this.address.add("logger");
            this.address.add(category);
        }
    }

    public static class GetLoggersRequest
    extends ManagementRequest<GetLoggersResponse> {
        @JsonProperty(value="child-type")
        public String childType = "logger";

        GetLoggersRequest(Server server, User user) {
            super(GetLoggersResponse.class, "read-children-names", server, user);
            this.address.add("subsystem");
            this.address.add("logging");
        }
    }

    public static class GetLoggingFileRequest
    extends ManagementRequest<GetLoggingFileResponse> {
        public String name = "server.log";
        public String lines;

        GetLoggingFileRequest(Server server, String numLines, User user) {
            super(GetLoggingFileResponse.class, "read-log-file", server, user);
            if (numLines == null || numLines.isEmpty()) {
                numLines = "200";
            }
            this.lines = numLines;
            this.address.add("subsystem");
            this.address.add("logging");
            this.address.add("log-file");
            this.address.add("server.log");
        }
    }

    public static class ReadConfigAsXmlRequest
    extends ManagementRequest<ReadConfigAsXmlResponse> {
        ReadConfigAsXmlRequest(Server server, User user) {
            super(ReadConfigAsXmlResponse.class, "read-config-as-xml-file", server, user, true);
        }

        @Override
        ReadConfigAsXmlResponse getResponse(String fileContent) throws JsonProcessingException {
            ReadConfigAsXmlResponse resp = new ReadConfigAsXmlResponse();
            resp.result = fileContent;
            return resp;
        }
    }

    public static abstract class ReadAttributeRequest<R extends ReadAttributeResponse>
    extends ManagementRequest<R> {
        public String name;

        protected ReadAttributeRequest(Class<R> responseClass, Server server, User user, String attribute) {
            super(responseClass, "read-attribute", server, user);
            this.name = attribute;
        }
    }

    public static class EnableLoggerRequest
    extends ManagementRequest<ManagementResponse> {
        public String value = "ALL";
        public String name = "level";

        EnableLoggerRequest(Server server, User user, String category) {
            super(ManagementResponse.class, "write-attribute", server, user);
            this.address.add("subsystem");
            this.address.add("logging");
            this.address.add("logger");
            this.address.add(category);
        }
    }

    public static class AddLoggerRequest
    extends ManagementRequest<ManagementResponse> {
        public String level = "ALL";

        AddLoggerRequest(Server server, User user, String category) {
            super(ManagementResponse.class, "add", server, user);
            this.address.add("subsystem");
            this.address.add("logging");
            this.address.add("logger");
            this.address.add(category);
        }
    }

    public static class Deployment {
        public List<Map<String, String>> address;
        public String outcome;
        public String result;
        @JsonProperty(value="rolled-back")
        public String rolledBack;

        public String toString() {
            if (this.address.isEmpty()) {
                return "No deployments.";
            }
            return " Deployment : " + this.address.get(this.address.size() - 1).get("deployment") + "\n, status " + this.result + ", outcome " + this.outcome;
        }
    }
}

