/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.dynamic.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextException;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextSPI;
import org.wildfly.security.dynamic.ssl.ElytronMessages;

final class DynamicSSLSocketFactory
extends SSLSocketFactory {
    private DynamicSSLContextSPI dynamicSSLContextImpl;
    private volatile String[] intersectionCipherSuite;
    private SSLSocketFactory configuredDefaultSslSocketFactory;

    DynamicSSLSocketFactory(SSLSocketFactory configuredDefaultSslSocketFactory, DynamicSSLContextSPI dynamicSSLContextImpl) {
        Assert.assertNotNull(configuredDefaultSslSocketFactory);
        Assert.assertNotNull(dynamicSSLContextImpl);
        this.configuredDefaultSslSocketFactory = configuredDefaultSslSocketFactory;
        this.dynamicSSLContextImpl = dynamicSSLContextImpl;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.configuredDefaultSslSocketFactory.createSocket();
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.createSocketBasedOnPeerInfo(null, port, address, null, null, null, null);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocketBasedOnPeerInfo(host, port, null, null, null, null, null);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createSocketBasedOnPeerInfo(host, port, null, localAddress, localPort, null, null);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createSocketBasedOnPeerInfo(null, port, address, localAddress, localPort, null, null);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.createSocketBasedOnPeerInfo(host, port, null, null, null, socket, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.configuredDefaultSslSocketFactory.getDefaultCipherSuites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSupportedCipherSuites() {
        String[] val = this.intersectionCipherSuite;
        if (val == null) {
            DynamicSSLSocketFactory dynamicSSLSocketFactory = this;
            synchronized (dynamicSSLSocketFactory) {
                val = this.intersectionCipherSuite;
                if (this.intersectionCipherSuite == null) {
                    this.intersectionCipherSuite = this.getIntersection();
                    val = this.intersectionCipherSuite;
                }
            }
        }
        return val;
    }

    private Socket createSocketBasedOnPeerInfo(String hostname, Integer port, InetAddress address, InetAddress localAddress, Integer localPort, Socket socket, Boolean autoClose) throws IOException {
        try {
            SSLContext sslContext = this.dynamicSSLContextImpl.getSSLContext(new URI(null, null, hostname == null ? address.getHostName() : hostname, port, null, null, null));
            if (sslContext == null) {
                throw ElytronMessages.log.configuredSSLContextIsNull();
            }
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            if (socketFactory instanceof DynamicSSLSocketFactory && socketFactory.equals(this)) {
                throw ElytronMessages.log.dynamicSSLContextCreatesLoop();
            }
            if (socket != null && autoClose != null) {
                return socketFactory.createSocket(socket, hostname, port, autoClose);
            }
            if (address != null) {
                return localAddress == null ? socketFactory.createSocket(address, (int)port) : socketFactory.createSocket(address, (int)port, localAddress, (int)localPort);
            }
            if (localAddress != null && localPort != null) {
                return socketFactory.createSocket(hostname, (int)port, localAddress, (int)localPort);
            }
            return socketFactory.createSocket(hostname, (int)port);
        }
        catch (URISyntaxException e) {
            throw new UnknownHostException(e.getMessage());
        }
        catch (DynamicSSLContextException e) {
            throw new IOException(e);
        }
    }

    private String[] getIntersection() {
        List<SSLContext> sslContexts;
        try {
            sslContexts = this.dynamicSSLContextImpl.getConfiguredSSLContexts();
        }
        catch (DynamicSSLContextException e) {
            throw ElytronMessages.log.unableToGetConfiguredSSLContexts();
        }
        if (sslContexts == null) {
            throw ElytronMessages.log.configuredSSLContextsAreNull();
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        ArrayList intersection = new ArrayList();
        sslContexts.forEach(c -> {
            String[] cipherSuites;
            for (String cipherSuite : cipherSuites = c.getSocketFactory().getSupportedCipherSuites()) {
                counts.merge(cipherSuite, 1, (a, b) -> a + b);
            }
        });
        List<SSLContext> finalSslContexts = sslContexts;
        counts.forEach((c, v) -> {
            if (finalSslContexts.size() == v.intValue()) {
                intersection.add(c);
            }
        });
        return intersection.toArray(new String[0]);
    }
}

