/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.wildfly.metrics.scheduler.ModelControllerClientFactory;
import org.wildfly.metrics.scheduler.TopologyChangeListener;
import org.wildfly.metrics.scheduler.config.Address;
import org.wildfly.metrics.scheduler.config.Configuration;
import org.wildfly.metrics.scheduler.config.ResourceRef;
import org.wildfly.metrics.scheduler.diagnose.Diagnostics;
import org.wildfly.metrics.scheduler.polling.ClientFactoryImpl;
import org.wildfly.metrics.scheduler.polling.IntervalBasedScheduler;
import org.wildfly.metrics.scheduler.polling.Scheduler;
import org.wildfly.metrics.scheduler.polling.Task;
import org.wildfly.metrics.scheduler.storage.BufferedStorageDispatcher;
import org.wildfly.metrics.scheduler.storage.RHQStorageAdapter;
import org.wildfly.metrics.scheduler.storage.StorageAdapter;

public class Service
implements TopologyChangeListener {
    private final StorageAdapter storageAdapter;
    private Configuration configuration;
    private Scheduler scheduler;
    private Diagnostics diagnostics;
    private ScheduledReporter reporter;
    private boolean started = false;
    private BufferedStorageDispatcher completionHandler;

    public Service(Configuration configuration) {
        this(configuration, new ClientFactoryImpl(configuration.getHost(), configuration.getPort(), configuration.getUsername(), configuration.getPassword()));
    }

    public Service(Configuration configuration, ModelControllerClientFactory clientFactory) {
        this.configuration = configuration;
        MetricRegistry metrics = new MetricRegistry();
        this.diagnostics = this.createDiagnostics(metrics);
        this.storageAdapter = new RHQStorageAdapter(configuration, this.diagnostics);
        this.reporter = ConsoleReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        this.completionHandler = new BufferedStorageDispatcher(this.storageAdapter, this.diagnostics);
        this.scheduler = new IntervalBasedScheduler(clientFactory, this.diagnostics, configuration.getSchedulerThreads());
    }

    private Diagnostics createDiagnostics(final MetricRegistry metrics) {
        return new Diagnostics(){
            private final Timer requestTimer;
            private final Meter delayCounter;
            private final Meter taskErrorCounter;
            private final Meter storageError;
            private final Counter storageBuffer;
            {
                this.requestTimer = metrics.timer(MetricRegistry.name((String)"dmr-request-timer", (String[])new String[0]));
                this.delayCounter = metrics.meter(MetricRegistry.name((String)"task-delay-rate", (String[])new String[0]));
                this.taskErrorCounter = metrics.meter(MetricRegistry.name((String)"task-error-rate", (String[])new String[0]));
                this.storageError = metrics.meter(MetricRegistry.name((String)"storage-error-rate", (String[])new String[0]));
                this.storageBuffer = metrics.counter(MetricRegistry.name((String)"storage-buffer-size", (String[])new String[0]));
            }

            @Override
            public Timer getRequestTimer() {
                return this.requestTimer;
            }

            @Override
            public Meter getDelayedRate() {
                return this.delayCounter;
            }

            @Override
            public Meter getErrorRate() {
                return this.taskErrorCounter;
            }

            @Override
            public Meter getStorageErrorRate() {
                return this.storageError;
            }

            @Override
            public Counter getStorageBufferSize() {
                return this.storageBuffer;
            }
        };
    }

    public void start(String host, String server) {
        List<Task> tasks = this.createTasks(host, server, this.configuration.getResourceRefs());
        this.completionHandler.start();
        this.scheduler.schedule(tasks, this.completionHandler);
    }

    private List<Task> createTasks(String host, String server, List<ResourceRef> resourceRefs) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (ResourceRef ref : resourceRefs) {
            String attribute = ref.getAttribute();
            String subref = null;
            int i = attribute.indexOf("#");
            if (i > 0) {
                subref = attribute.substring(i + 1, attribute.length());
                attribute = attribute.substring(0, i);
            }
            tasks.add(new Task(host, server, Address.apply(ref.getAddress()), attribute, subref, ref.getInterval()));
        }
        return tasks;
    }

    public void stop() {
        this.completionHandler.shutdown();
        this.scheduler.shutdown();
        this.reporter.stop();
        this.reporter.report();
    }

    @Override
    public void onChange() {
    }

    public void reportEvery(int period, TimeUnit unit) {
        if (!this.started) {
            this.reporter.start((long)period, unit);
        }
    }
}

