/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wildfly.metrics.scheduler.config.Configuration;
import org.wildfly.metrics.scheduler.config.ResourceRef;

public class ConfigurationInstance
implements Configuration {
    private final List<ResourceRef> resourceRefs;
    private int schedulerThreads = 2;
    private String host;
    private int port;
    private String user;
    private String password;
    private String rhqUrl = "http://localhost:8080/rhq-metrics/metrics";
    private String influxUrl = "http://sandbox.influxdb.com:8086";
    private String influxUser;
    private String influxPassword;
    private String influxDb;

    public ConfigurationInstance(String host, int port) {
        this(host, port, new ArrayList<ResourceRef>());
    }

    public ConfigurationInstance(String host, int port, List<ResourceRef> resourceRefs) {
        this.host = host;
        this.port = port;
        this.resourceRefs = resourceRefs;
    }

    @Override
    public List<ResourceRef> getResourceRefs() {
        return Collections.unmodifiableList(this.resourceRefs);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSchedulerThreads(int schedulerThreads) {
        this.schedulerThreads = schedulerThreads;
    }

    @Override
    public int getSchedulerThreads() {
        return this.schedulerThreads;
    }

    @Override
    public String getInfluxUrl() {
        return this.influxUrl;
    }

    public void setInfluxUrl(String influxUrl) {
        this.influxUrl = influxUrl;
    }

    @Override
    public String getInfluxUser() {
        return this.influxUser;
    }

    @Override
    public String getInfluxPassword() {
        return this.influxPassword;
    }

    @Override
    public String getInfluxDBName() {
        return this.influxDb;
    }

    public void setInfluxUser(String influxUser) {
        this.influxUser = influxUser;
    }

    public void setInfluxPassword(String influxPassword) {
        this.influxPassword = influxPassword;
    }

    public void setInfluxDb(String influxDb) {
        this.influxDb = influxDb;
    }

    @Override
    public String getRHQUrl() {
        return this.rhqUrl;
    }

    public void setRhqUrl(String rhqUrl) {
        this.rhqUrl = rhqUrl;
    }

    public void addResourceRef(ResourceRef ref) {
        this.resourceRefs.add(ref);
    }
}

