/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.config;

import java.util.concurrent.TimeUnit;

public enum Interval {
    EACH_SECOND(1, TimeUnit.SECONDS),
    TWO_SECONDS(2, TimeUnit.SECONDS),
    FIVE_SECONDS(5, TimeUnit.SECONDS),
    EACH_MINUTE(1, TimeUnit.MINUTES),
    TWO_MINUTES(2, TimeUnit.MINUTES),
    FIVE_MINUTES(5, TimeUnit.MINUTES),
    TEN_MINUTES(10, TimeUnit.MINUTES),
    TWENTY_MINUTES(20, TimeUnit.MINUTES),
    THIRTY_MINUTES(30, TimeUnit.MINUTES),
    EACH_HOUR(1, TimeUnit.HOURS),
    TWO_HOURS(2, TimeUnit.HOURS),
    SIX_HOURS(6, TimeUnit.HOURS),
    TWELVE_HOURS(12, TimeUnit.HOURS),
    EACH_DAY(1, TimeUnit.DAYS);

    private final int val;
    private final TimeUnit unit;

    private Interval(int val, TimeUnit unit) {
        this.val = val;
        this.unit = unit;
    }

    public long millis() {
        return TimeUnit.MILLISECONDS.convert(this.val, this.unit);
    }
}

