/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.polling;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.metrics.scheduler.ModelControllerClientFactory;
import org.wildfly.metrics.scheduler.diagnose.Diagnostics;
import org.wildfly.metrics.scheduler.polling.AbstractScheduler;
import org.wildfly.metrics.scheduler.polling.IntervalGrouping;
import org.wildfly.metrics.scheduler.polling.ReadAttributeOperationBuilder;
import org.wildfly.metrics.scheduler.polling.Scheduler;
import org.wildfly.metrics.scheduler.polling.Task;
import org.wildfly.metrics.scheduler.polling.TaskGroup;
import org.wildfly.metrics.scheduler.storage.Sample;

public class IntervalBasedScheduler
extends AbstractScheduler {
    private final ScheduledExecutorService executorService;
    private final List<ScheduledFuture> jobs;
    private final int poolSize;
    private final ModelControllerClientFactory clientFactory;
    private final Diagnostics monitor;
    private ConcurrentLinkedQueue<ModelControllerClient> connectionPool = new ConcurrentLinkedQueue();

    public IntervalBasedScheduler(ModelControllerClientFactory clientFactory, Diagnostics monitor, int poolSize) {
        this.clientFactory = clientFactory;
        this.monitor = monitor;
        this.poolSize = poolSize;
        this.executorService = Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                System.out.println("<< created new executor >>");
                return new Thread(r);
            }
        });
        this.jobs = new LinkedList<ScheduledFuture>();
    }

    @Override
    public void schedule(List<Task> tasks, Scheduler.CompletionHandler completionHandler) {
        this.verifyState(Scheduler.State.STOPPED);
        List<TaskGroup> groups = new IntervalGrouping().apply(tasks);
        System.out.println("<< Number of Tasks: " + tasks.size() + " >>");
        System.out.println("<< Number of Task Groups: " + groups.size() + " >>");
        for (int i = 0; i < this.poolSize; ++i) {
            try {
                this.connectionPool.add(this.clientFactory.createClient());
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (TaskGroup group : groups) {
            this.jobs.add(this.executorService.scheduleWithFixedDelay(new IO(group, completionHandler), group.getOffsetMillis(), group.getInterval().millis(), TimeUnit.MILLISECONDS));
        }
        this.pushState(Scheduler.State.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        block14: {
            this.verifyState(Scheduler.State.RUNNING);
            try {
                for (ScheduledFuture job : this.jobs) {
                    job.cancel(false);
                }
                this.executorService.shutdown();
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break block14;
            }
            finally {
                for (ModelControllerClient client : this.connectionPool) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.pushState(Scheduler.State.STOPPED);
            }
            for (ModelControllerClient client : this.connectionPool) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.pushState(Scheduler.State.STOPPED);
        }
    }

    private class IO
    implements Runnable {
        private static final String OUTCOME = "outcome";
        private static final String RESULT = "result";
        private static final String FAILURE_DESCRIPTION = "failure-description";
        private static final String SUCCESS = "success";
        private final TaskGroup group;
        private final Scheduler.CompletionHandler completionHandler;
        private final ModelNode operation;

        private IO(TaskGroup group, Scheduler.CompletionHandler completionHandler) {
            this.group = group;
            this.completionHandler = completionHandler;
            this.operation = new ReadAttributeOperationBuilder().createOperation(group);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (IntervalBasedScheduler.this.connectionPool.isEmpty()) {
                throw new IllegalStateException("Connection pool expired!");
            }
            ModelControllerClient client = (ModelControllerClient)IntervalBasedScheduler.this.connectionPool.poll();
            try {
                Timer.Context requestContext = IntervalBasedScheduler.this.monitor.getRequestTimer().time();
                ModelNode response = client.execute(this.operation);
                long durationMs = requestContext.stop() / 1000000L;
                String outcome = response.get(OUTCOME).asString();
                if (SUCCESS.equals(outcome)) {
                    if (durationMs > this.group.getInterval().millis()) {
                        IntervalBasedScheduler.this.monitor.getDelayedRate().mark(1L);
                    }
                    List steps = response.get(RESULT).asPropertyList();
                    assert (steps.size() == this.group.size()) : "group structure doesn't match actual response structure";
                    int i = 0;
                    for (Property step : steps) {
                        Task task = this.group.getTask(i);
                        ModelNode data = step.getValue();
                        Double value = null;
                        value = task.getSubref() != null ? Double.valueOf(data.get(RESULT).get(task.getSubref()).asDouble()) : Double.valueOf(data.get(RESULT).asDouble());
                        this.completionHandler.onCompleted(new Sample(task, value));
                        ++i;
                    }
                } else {
                    IntervalBasedScheduler.this.monitor.getErrorRate().mark(1L);
                    this.completionHandler.onFailed(new RuntimeException(response.get(FAILURE_DESCRIPTION).asString()));
                }
            }
            catch (Throwable e) {
                IntervalBasedScheduler.this.monitor.getErrorRate().mark(1L);
                this.completionHandler.onFailed(e);
            }
            finally {
                IntervalBasedScheduler.this.connectionPool.add(client);
            }
        }
    }
}

