/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.polling;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import org.wildfly.metrics.scheduler.config.Interval;
import org.wildfly.metrics.scheduler.polling.Task;

public class TaskGroup
implements Iterable<Task> {
    private final String id = UUID.randomUUID().toString();
    private final Interval interval;
    private final long offsetMillis;
    private final LinkedList<Task> tasks;

    public TaskGroup(Interval interval) {
        this.offsetMillis = 0L;
        this.interval = interval;
        this.tasks = new LinkedList();
    }

    public void addTask(Task task) {
        this.verifyInterval(task);
        this.tasks.add(task);
    }

    public boolean addTasks(Collection<? extends Task> collection) {
        for (Task task : collection) {
            this.verifyInterval(task);
        }
        return this.tasks.addAll(collection);
    }

    private void verifyInterval(Task task) {
        if (task.getInterval() != this.interval) {
            throw new IllegalArgumentException("Wrong interval: Expected " + (Object)((Object)this.interval) + ", but got " + (Object)((Object)task.getInterval()));
        }
    }

    public int size() {
        return this.tasks.size();
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    @Override
    public Iterator<Task> iterator() {
        return Iterators.unmodifiableIterator(this.tasks.iterator());
    }

    public String getId() {
        return this.id;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public long getOffsetMillis() {
        return this.offsetMillis;
    }

    public Task getTask(int i) {
        return this.tasks.get(i);
    }
}

