/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.storage;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Serie;
import org.wildfly.metrics.scheduler.config.Configuration;
import org.wildfly.metrics.scheduler.diagnose.Diagnostics;
import org.wildfly.metrics.scheduler.storage.Sample;
import org.wildfly.metrics.scheduler.storage.StorageAdapter;

public class InfluxStorageAdapter
implements StorageAdapter {
    private final InfluxDB influxDB;
    private final String dbName;
    private final Diagnostics diagnostics;

    public InfluxStorageAdapter(Configuration config, Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.influxDB = InfluxDBFactory.connect((String)config.getInfluxUrl(), (String)config.getInfluxUser(), (String)config.getInfluxPassword());
        this.dbName = config.getInfluxDBName();
    }

    @Override
    public void store(Set<Sample> samples) {
        try {
            Serie[] series = new Serie[samples.size()];
            int i = 0;
            for (Sample sample : samples) {
                Serie dataPoint;
                series[i] = dataPoint = new Serie.Builder(sample.getTask().getAttribute()).columns(new String[]{"sample"}).values(new Object[]{sample.getValue()}).build();
                ++i;
            }
            this.influxDB.write(this.dbName, TimeUnit.MILLISECONDS, series);
        }
        catch (Throwable t) {
            this.diagnostics.getStorageErrorRate().mark(1L);
            t.printStackTrace();
        }
    }
}

