/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.config;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Address
implements Iterable<Tuple> {
    private final List<Tuple> tuples = new ArrayList<Tuple>();

    public static Address apply(String address) {
        List tokens = address == null ? Collections.emptyList() : Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"/=")).trimResults().omitEmptyStrings().splitToList((CharSequence)address);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(tokens.size() / 2 + 1);
        Iterator iterator = tokens.iterator();
        while (iterator.hasNext()) {
            String type = (String)iterator.next();
            String name = iterator.hasNext() ? (String)iterator.next() : "";
            tuples.add(new Tuple(type, name));
        }
        return new Address(tuples);
    }

    private Address(List<Tuple> tuples) {
        if (tuples != null) {
            this.tuples.addAll(tuples);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.tuples.equals(address.tuples);
    }

    public int hashCode() {
        return this.tuples.hashCode();
    }

    public String toString() {
        return Joiner.on((char)'/').join(this.tuples);
    }

    @Override
    public Iterator<Tuple> iterator() {
        return Iterators.unmodifiableIterator(this.tuples.iterator());
    }

    public boolean isEmpty() {
        return this.tuples.isEmpty();
    }

    public boolean isBalanced() {
        for (Tuple tuple : this) {
            if (tuple.getValue() != null && tuple.getValue().length() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(Tuple tuple) {
        return !this.tuples.isEmpty() && this.tuples.get(0).equals(tuple);
    }

    public static class Tuple {
        private final String key;
        private final String value;

        public static Tuple apply(String tuple) {
            if (tuple == null) {
                throw new IllegalArgumentException("Tuple must not be null");
            }
            List tuples = Splitter.on((char)'=').omitEmptyStrings().trimResults().splitToList((CharSequence)tuple);
            if (tuples.isEmpty() || tuples.size() != 2) {
                throw new IllegalArgumentException("Malformed tuple: " + tuple);
            }
            return new Tuple((String)tuples.get(0), (String)tuples.get(1));
        }

        private Tuple(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple that = (Tuple)o;
            if (!this.value.equals(that.value)) {
                return false;
            }
            return this.key.equals(that.key);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

