/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wildfly.metrics.scheduler.config.Configuration;
import org.wildfly.metrics.scheduler.config.ResourceRef;

public class ConfigurationInstance
implements Configuration {
    private final List<ResourceRef> resourceRefs;
    private int schedulerThreads = 2;
    private String host;
    private int port;
    private String user;
    private String password;
    private String storageUrl = "http://sandbox.influxdb.com:8086";
    private String storageUser = "admin";
    private String storagePassword = "password123";
    private String storageDb = "wildfly";
    private String storageToken = null;
    private Configuration.Storage storageAdapter = Configuration.Storage.INFLUX;
    private Configuration.Diagnostics diagnostics = Configuration.Diagnostics.CONSOLE;

    public ConfigurationInstance() {
        this("localhost", 9990, new ArrayList<ResourceRef>());
    }

    public ConfigurationInstance(String host, int port) {
        this(host, port, new ArrayList<ResourceRef>());
    }

    public ConfigurationInstance(String host, int port, List<ResourceRef> resourceRefs) {
        this.host = host;
        this.port = port;
        this.resourceRefs = resourceRefs;
    }

    @Override
    public List<ResourceRef> getResourceRefs() {
        return Collections.unmodifiableList(this.resourceRefs);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUsername() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSchedulerThreads(int schedulerThreads) {
        this.schedulerThreads = schedulerThreads;
    }

    @Override
    public int getSchedulerThreads() {
        return this.schedulerThreads;
    }

    @Override
    public String getStorageUrl() {
        return this.storageUrl;
    }

    @Override
    public String getStorageUser() {
        return this.storageUser;
    }

    @Override
    public String getStoragePassword() {
        return this.storagePassword;
    }

    @Override
    public String getStorageDBName() {
        return this.storageDb;
    }

    @Override
    public Configuration.Storage getStorageAdapter() {
        return this.storageAdapter;
    }

    public void setStorageAdapter(Configuration.Storage storageAdapter) {
        this.storageAdapter = storageAdapter;
    }

    public void setStorageUrl(String storageUrl) {
        this.storageUrl = storageUrl;
    }

    public void setStorageUser(String storageUser) {
        this.storageUser = storageUser;
    }

    public void setStoragePassword(String storagePassword) {
        this.storagePassword = storagePassword;
    }

    public void setStorageDb(String storageDb) {
        this.storageDb = storageDb;
    }

    public void addResourceRef(ResourceRef ref) {
        this.resourceRefs.add(ref);
    }

    public String getStorageDb() {
        return this.storageDb;
    }

    @Override
    public String getStorageToken() {
        return this.storageToken;
    }

    public void setStorageToken(String storageToken) {
        this.storageToken = storageToken;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public Configuration.Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(Configuration.Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }
}

