/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.diagnose;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.wildfly.metrics.scheduler.config.Address;
import org.wildfly.metrics.scheduler.config.Interval;
import org.wildfly.metrics.scheduler.polling.Task;
import org.wildfly.metrics.scheduler.storage.Sample;
import org.wildfly.metrics.scheduler.storage.StorageAdapter;

public class StorageReporter
extends ScheduledReporter {
    private static StorageAdapter storageAdapter;
    private final Locale locale;
    private final Clock clock;
    private final DateFormat dateFormat;

    private StorageReporter(MetricRegistry registry, Locale locale, Clock clock, TimeZone timeZone, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, StorageAdapter storageAdapter) {
        super(registry, "storage-reporter", filter, rateUnit, durationUnit);
        this.locale = locale;
        this.clock = clock;
        StorageReporter.storageAdapter = storageAdapter;
        this.dateFormat = DateFormat.getDateTimeInstance(3, 2, locale);
        this.dateFormat.setTimeZone(timeZone);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        HashSet<Sample> samples;
        if (!gauges.isEmpty()) {
            samples = new HashSet<Sample>(gauges.size());
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                Gauge gauge = entry.getValue();
                samples.add(new Sample(new Task("foo", "bar", Address.apply("service=metric-scheduler"), entry.getKey(), null, Interval.EACH_SECOND), ((Integer)gauge.getValue()).intValue()));
            }
            storageAdapter.store(samples);
        }
        if (!counters.isEmpty()) {
            samples = new HashSet(counters.size());
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                samples.add(new Sample(new Task("foo", "bar", Address.apply("service=metric-scheduler"), entry.getKey(), null, Interval.EACH_SECOND), ((Counter)entry.getValue()).getCount()));
            }
            storageAdapter.store(samples);
        }
        if (!meters.isEmpty()) {
            samples = new HashSet(meters.size());
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                Meter meter = (Meter)entry.getValue();
                samples.add(new Sample(new Task("foo", "bar", Address.apply("service=metric-scheduler"), entry.getKey(), null, Interval.EACH_SECOND), meter.getOneMinuteRate()));
            }
            storageAdapter.store(samples);
        }
        if (!timers.isEmpty()) {
            samples = new HashSet(timers.size());
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                Timer timer = (Timer)entry.getValue();
                samples.add(new Sample(new Task("foo", "bar", Address.apply("service=metric-scheduler"), entry.getKey(), null, Interval.EACH_SECOND), timer.getSnapshot().get75thPercentile()));
            }
            storageAdapter.store(samples);
        }
    }

    public static Builder forRegistry(MetricRegistry registry, StorageAdapter storageAdapter) {
        return new Builder(registry, storageAdapter);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private final StorageAdapter storageAdapter;
        private PrintStream output;
        private Locale locale;
        private Clock clock;
        private TimeZone timeZone;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry, StorageAdapter storageAdapter) {
            this.registry = registry;
            this.storageAdapter = storageAdapter;
            this.locale = Locale.getDefault();
            this.clock = Clock.defaultClock();
            this.timeZone = TimeZone.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder outputTo(PrintStream output) {
            this.output = output;
            return this;
        }

        public Builder formattedFor(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder formattedFor(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public StorageReporter build() {
            return new StorageReporter(this.registry, this.locale, this.clock, this.timeZone, this.rateUnit, this.durationUnit, this.filter, this.storageAdapter);
        }
    }
}

