/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.polling;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.metrics.scheduler.ModelControllerClientFactory;

public class ClientFactoryImpl
implements ModelControllerClientFactory {
    private String host;
    private int port;
    private String username;
    private String password;

    public ClientFactoryImpl(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Override
    public ModelControllerClient createClient() {
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(ClientFactoryImpl.this.username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(ClientFactoryImpl.this.password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        try {
            return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(this.host), (int)this.port, (CallbackHandler)callbackHandler);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed ot create controller client", e);
        }
    }
}

