/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.polling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.wildfly.metrics.scheduler.config.Interval;
import org.wildfly.metrics.scheduler.polling.Task;
import org.wildfly.metrics.scheduler.polling.TaskGroup;
import org.wildfly.metrics.scheduler.polling.TaskGrouping;

public class IntervalGrouping
implements TaskGrouping {
    @Override
    public List<TaskGroup> apply(List<Task> tasks) {
        Collections.sort(tasks, new Comparator<Task>(){

            @Override
            public int compare(Task t1, Task t2) {
                return new Long(t1.getInterval().millis()).compareTo(t2.getInterval().millis());
            }
        });
        ArrayList<TaskGroup> groups = new ArrayList<TaskGroup>();
        Interval interval = tasks.get(0).getInterval();
        TaskGroup taskGroup = new TaskGroup(interval);
        groups.add(taskGroup);
        for (Task task : tasks) {
            if (!task.getInterval().equals(interval)) {
                interval = task.getInterval();
                groups.add(new TaskGroup(task.getInterval()));
            }
            ((TaskGroup)groups.get(groups.size() - 1)).addTask(task);
        }
        return groups;
    }
}

