/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.polling;

import java.util.ArrayList;
import org.jboss.dmr.ModelNode;
import org.wildfly.metrics.scheduler.config.Address;
import org.wildfly.metrics.scheduler.polling.OperationBuilder;
import org.wildfly.metrics.scheduler.polling.Task;
import org.wildfly.metrics.scheduler.polling.TaskGroup;

public class ReadAttributeOperationBuilder
implements OperationBuilder {
    @Override
    public ModelNode createOperation(TaskGroup group) {
        if (group.isEmpty()) {
            throw new IllegalArgumentException("Empty groups are not allowed");
        }
        ModelNode comp = new ModelNode();
        ArrayList<ModelNode> steps = new ArrayList<ModelNode>();
        comp.get("address").setEmptyList();
        comp.get("operation").set("composite");
        for (Task task : group) {
            steps.add(this.readAttribute(task));
        }
        comp.get("steps").set(steps);
        return comp;
    }

    private ModelNode readAttribute(Task task) {
        ModelNode node = new ModelNode();
        Address address = task.getAddress();
        for (Address.Tuple tuple : address) {
            node.get("address").add(tuple.getKey(), tuple.getValue());
        }
        node.get("operation").set("read-attribute");
        node.get("name").set(task.getAttribute());
        return node;
    }
}

