/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.storage;

import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.wildfly.metrics.scheduler.diagnose.Diagnostics;
import org.wildfly.metrics.scheduler.polling.Scheduler;
import org.wildfly.metrics.scheduler.storage.Sample;
import org.wildfly.metrics.scheduler.storage.StorageAdapter;

public class BufferedStorageDispatcher
implements Scheduler.CompletionHandler {
    private static final int MAX_BATCH_SIZE = 24;
    private static final int BUFFER_SIZE = 100;
    private final StorageAdapter storageAdapter;
    private final Diagnostics diagnostics;
    private final BlockingQueue<Sample> queue;
    private final Worker worker;

    public BufferedStorageDispatcher(StorageAdapter storageAdapter, Diagnostics diagnostics) {
        this.storageAdapter = storageAdapter;
        this.diagnostics = diagnostics;
        this.queue = new ArrayBlockingQueue<Sample>(100);
        this.worker = new Worker(this.queue);
    }

    public void start() {
        this.worker.start();
    }

    public void shutdown() {
        this.worker.setKeepRunnig(false);
    }

    @Override
    public void onCompleted(Sample sample) {
        if (this.queue.remainingCapacity() <= 0) {
            throw new RuntimeException("buffer capacity exceeded");
        }
        this.diagnostics.getStorageBufferSize().inc();
        this.queue.add(sample);
    }

    @Override
    public void onFailed(Throwable e) {
        e.printStackTrace();
    }

    public class Worker
    extends Thread {
        private final BlockingQueue<Sample> queue;
        private boolean keepRunning = true;

        public Worker(BlockingQueue<Sample> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                while (this.keepRunning) {
                    Sample sample = this.queue.take();
                    HashSet<Sample> samples = new HashSet<Sample>();
                    this.queue.drainTo(samples, 24);
                    samples.add(sample);
                    BufferedStorageDispatcher.this.diagnostics.getStorageBufferSize().dec((long)samples.size());
                    BufferedStorageDispatcher.this.storageAdapter.store(samples);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setKeepRunnig(boolean keepRunning) {
            this.keepRunning = keepRunning;
        }
    }
}

