/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.metrics.scheduler.storage;

import java.util.ArrayList;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.rhq.metrics.client.common.Batcher;
import org.rhq.metrics.client.common.SingleMetric;
import org.wildfly.metrics.scheduler.config.Configuration;
import org.wildfly.metrics.scheduler.diagnose.Diagnostics;
import org.wildfly.metrics.scheduler.polling.Task;
import org.wildfly.metrics.scheduler.storage.Sample;
import org.wildfly.metrics.scheduler.storage.StorageAdapter;

public class RHQStorageAdapter
implements StorageAdapter {
    private Configuration config;
    private Diagnostics diagnostics;
    private HttpClient httpclient = new DefaultHttpClient();

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public void setDiagnostics(Diagnostics diag) {
        this.diagnostics = diag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Set<Sample> samples) {
        HttpPost post = new HttpPost(this.config.getStorageUrl());
        try {
            ArrayList<SingleMetric> metrics = new ArrayList<SingleMetric>();
            for (Sample sample : samples) {
                Task task = sample.getTask();
                String source = task.getHost() + "." + task.getServer() + "." + task.getAttribute();
                metrics.add(new SingleMetric(source, sample.getTimestamp(), Double.valueOf(sample.getValue())));
            }
            if (metrics.size() > 0) {
                post.setHeader("Content-Type", "application/json;charset=utf-8");
                post.setEntity((HttpEntity)new StringEntity(Batcher.metricListToJson(metrics)));
                HttpResponse httpResponse = this.httpclient.execute((HttpUriRequest)post);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine.getStatusCode() != 200) {
                    throw new Exception("HTTP Status " + statusLine.getStatusCode() + ": " + statusLine);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
        finally {
            post.releaseConnection();
        }
    }
}

