/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.cassandra;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.cassandra.CassandraInteraction;
import org.wildfly.extension.nosql.driver.cassandra.ConfigurationBuilder;
import org.wildfly.extension.nosql.subsystem.cassandra.CassandraSubsystemService;
import org.wildfly.nosql.common.NoSQLLogger;
import org.wildfly.nosql.common.spi.NoSQLConnection;

public class CassandraClientConnectionsService
implements Service<CassandraClientConnectionsService>,
NoSQLConnection {
    private final ConfigurationBuilder configurationBuilder;
    private Map<String, OutboundSocketBinding> outboundSocketBindings = new HashMap<String, OutboundSocketBinding>();
    private final CassandraInteraction cassandraInteraction;
    private final Class clusterClass;
    private final Class sessionClass;
    private Object cluster;
    private Object session;
    private final InjectedValue<CassandraSubsystemService> cassandraSubsystemServiceInjectedValue = new InjectedValue();
    private final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();

    public CassandraClientConnectionsService(ConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
        this.cassandraInteraction = new CassandraInteraction(configurationBuilder);
        this.clusterClass = this.cassandraInteraction.getClusterClass();
        this.sessionClass = this.cassandraInteraction.getSessionClass();
    }

    public InjectedValue<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    public Injector<OutboundSocketBinding> getOutboundSocketBindingInjector(String name) {
        return new MapInjector(this.outboundSocketBindings, (Object)name);
    }

    public InjectedValue<CassandraSubsystemService> getCassandraSubsystemServiceInjectedValue() {
        return this.cassandraSubsystemServiceInjectedValue;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            ((CassandraSubsystemService)this.cassandraSubsystemServiceInjectedValue.getValue()).addModuleNameFromJndi(this.configurationBuilder.getJNDIName(), this.configurationBuilder.getModuleName());
            ((CassandraSubsystemService)this.cassandraSubsystemServiceInjectedValue.getValue()).addModuleNameFromProfile(this.configurationBuilder.getDescription(), this.configurationBuilder.getModuleName());
            for (OutboundSocketBinding target : this.outboundSocketBindings.values()) {
                if (target.getDestinationPort() > 0) {
                    this.cassandraInteraction.withPort(target.getDestinationPort());
                }
                if (target.getUnresolvedDestinationAddress() == null) continue;
                this.cassandraInteraction.addContactPoint(target.getUnresolvedDestinationAddress());
            }
            if (this.subjectFactory.getOptionalValue() != null) {
                this.cassandraInteraction.subjectFactory((SubjectFactory)this.subjectFactory.getOptionalValue());
            }
            if (this.configurationBuilder.getDescription() != null) {
                this.cassandraInteraction.withClusterName(this.configurationBuilder.getDescription());
            }
            if (this.configurationBuilder.isWithSSL()) {
                this.cassandraInteraction.withSSL();
            }
            this.cluster = this.cassandraInteraction.build();
            String keySpace = this.configurationBuilder.getKeySpace();
            if (keySpace != null) {
                this.session = this.cassandraInteraction.connect(this.cluster, keySpace);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("could not setup Cassandra connection " + this.configurationBuilder.getDescription(), throwable);
        }
    }

    public void stop(StopContext stopContext) {
        try {
            ((CassandraSubsystemService)this.cassandraSubsystemServiceInjectedValue.getValue()).removeModuleNameFromJndi(this.configurationBuilder.getJNDIName());
            ((CassandraSubsystemService)this.cassandraSubsystemServiceInjectedValue.getValue()).removeModuleNameFromProfile(this.configurationBuilder.getDescription());
            if (this.session != null) {
                this.cassandraInteraction.sessionClose(this.session);
                this.session = null;
            }
            this.cassandraInteraction.clusterClose(this.cluster);
            this.cluster = null;
        }
        catch (Throwable throwable) {
            NoSQLLogger.ROOT_LOGGER.driverFailedToStop(throwable);
        }
    }

    public CassandraClientConnectionsService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Object getCluster() {
        return this.cluster;
    }

    public Object getSession() {
        return this.session;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (this.clusterClass.isAssignableFrom(clazz)) {
            return (T)this.cluster;
        }
        if (this.sessionClass.isAssignableFrom(clazz)) {
            return (T)this.session;
        }
        throw NoSQLLogger.ROOT_LOGGER.unassignable(clazz);
    }
}

