/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.cassandra;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.cassandra.ConfigurationBuilder;
import org.wildfly.nosql.common.MethodHandleBuilder;
import org.wildfly.nosql.common.NoSQLLogger;

public class CassandraInteraction {
    private final Class clusterClass;
    private final Class sessionClass;
    private final Class clusterBuilderClass;
    private final MethodHandle clusterBuilderMethod;
    private final MethodHandle clusterConnectMethod;
    private final MethodHandle clusterCloseMethod;
    private final MethodHandle builderBuildMethod;
    private final MethodHandle builderWithClusterNameMethod;
    private final MethodHandle builderWithPortMethod;
    private final MethodHandle builderWithCredentials;
    private final MethodHandle builderAddContactPointMethod;
    private final MethodHandle builderwithSSLMethod;
    private final MethodHandle sessionCloseMethod;
    private Object clusterBuilder;
    private volatile SubjectFactory subjectFactory;
    private final String securityDomain;

    public CassandraInteraction(ConfigurationBuilder configurationBuilder) {
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        methodHandleBuilder.classLoader(ModuleIdentifier.fromString((String)configurationBuilder.getModuleName()));
        this.clusterBuilderClass = methodHandleBuilder.className("com.datastax.driver.core.Cluster$Builder").getTargetClass();
        this.builderBuildMethod = methodHandleBuilder.method("build", new Class[0]);
        this.builderWithClusterNameMethod = methodHandleBuilder.method("withClusterName", new Class[]{String.class});
        this.builderWithCredentials = methodHandleBuilder.method("withCredentials", new Class[]{String.class, String.class});
        this.builderWithPortMethod = methodHandleBuilder.method("withPort", new Class[]{Integer.TYPE});
        this.builderAddContactPointMethod = methodHandleBuilder.method("addContactPoint", new Class[]{String.class});
        this.builderwithSSLMethod = methodHandleBuilder.method("withSSL", new Class[0]);
        this.clusterClass = methodHandleBuilder.className("com.datastax.driver.core.Cluster").getTargetClass();
        this.clusterConnectMethod = methodHandleBuilder.method("connect", new Class[]{String.class});
        this.clusterCloseMethod = methodHandleBuilder.method("close", new Class[0]);
        this.clusterBuilderMethod = methodHandleBuilder.staticMethod("builder", MethodType.methodType(this.clusterBuilderClass));
        this.sessionClass = methodHandleBuilder.className("com.datastax.driver.core.Session").getTargetClass();
        this.sessionCloseMethod = methodHandleBuilder.method("close", new Class[0]);
        this.securityDomain = configurationBuilder.getSecurityDomain();
    }

    private Object getBuilder() throws Throwable {
        if (this.clusterBuilder == null) {
            this.clusterBuilder = this.clusterBuilderMethod.invoke();
        }
        return this.clusterBuilder;
    }

    protected Object build() throws Throwable {
        return this.builderBuildMethod.invoke(this.getBuilder());
    }

    protected Object connect(Object cluster, String keySpace) throws Throwable {
        return this.clusterConnectMethod.invoke(cluster, keySpace);
    }

    protected void withClusterName(String clusterName) throws Throwable {
        this.builderWithClusterNameMethod.invoke(this.getBuilder(), clusterName);
    }

    protected void withPort(int port) throws Throwable {
        this.builderWithPortMethod.invoke(this.getBuilder(), port);
    }

    protected void withSSL() throws Throwable {
        this.builderwithSSLMethod.invoke(this.getBuilder());
    }

    protected void setCredential(String securityDomain) throws Throwable {
        if (securityDomain != null && this.subjectFactory != null) {
            try {
                Subject subject = this.subjectFactory.createSubject(securityDomain);
                Set<PasswordCredential> passwordCredentials = subject.getPrivateCredentials(PasswordCredential.class);
                PasswordCredential passwordCredential = passwordCredentials.iterator().next();
                this.withCredentials(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
            }
            catch (Throwable problem) {
                if (NoSQLLogger.ROOT_LOGGER.isTraceEnabled()) {
                    NoSQLLogger.ROOT_LOGGER.tracef(problem, "could not create subject for security domain '%s'", (Object)securityDomain);
                }
                throw problem;
            }
        }
    }

    private void withCredentials(String user, String password) throws Throwable {
        this.builderWithCredentials.invoke(this.getBuilder(), user, password);
    }

    protected void addContactPoint(String host) throws Throwable {
        this.builderAddContactPointMethod.invoke(this.getBuilder(), host);
    }

    protected void clusterClose(Object cluster) throws Throwable {
        this.clusterCloseMethod.invoke(cluster);
    }

    protected void sessionClose(Object session) throws Throwable {
        this.sessionCloseMethod.invoke(session);
    }

    public Class getClusterClass() {
        return this.clusterClass;
    }

    public Class getSessionClass() {
        return this.sessionClass;
    }

    public void subjectFactory(SubjectFactory subjectFactory) throws Throwable {
        this.subjectFactory = subjectFactory;
        this.setCredential(this.securityDomain);
    }
}

