/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.mongodb;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.nosql.subsystem.mongodb.MongoDriverDefinition;
import org.wildfly.extension.nosql.subsystem.mongodb.MongoSubsystemService;
import org.wildfly.nosql.common.DriverDependencyProcessor;
import org.wildfly.nosql.common.DriverScanDependencyProcessor;

public class MongoDriverSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final MongoDriverSubsystemAdd INSTANCE = new MongoDriverSubsystemAdd();
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    private MongoDriverSubsystemAdd() {
        super(MongoDriverDefinition.DRIVER_SERVICE_CAPABILITY, new AttributeDefinition[0]);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : MongoDriverDefinition.INSTANCE.getAttributes()) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.runtimeValidator.validate(operation.resolve());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                int PARSE_MONGO_DRIVER = 19459;
                int DEPENDENCIES_MONGO_DRIVER = 7955;
                processorTarget.addDeploymentProcessor("mongodb", Phase.PARSE, 19459, (DeploymentUnitProcessor)new DriverScanDependencyProcessor("mongodbsubsystem"));
                processorTarget.addDeploymentProcessor("mongodb", Phase.DEPENDENCIES, 7955, (DeploymentUnitProcessor)DriverDependencyProcessor.getInstance());
            }
        }, OperationContext.Stage.RUNTIME);
        this.startMongoDriverSubsysteService(context);
    }

    private void startMongoDriverSubsysteService(OperationContext context) {
        MongoSubsystemService mongoSubsystemService = new MongoSubsystemService();
        context.getServiceTarget().addService(MongoSubsystemService.serviceName(), (Service)mongoSubsystemService).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

