/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.neo4j.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.wildfly.extension.nosql.driver.neo4j.transaction.Neo4jXAResourceImpl;
import org.wildfly.extension.nosql.driver.neo4j.transaction.TransactionControl;

public class SessionProxy
implements InvocationHandler {
    private volatile Object underlyingSession;
    private volatile Object underlyingTransaction;
    private final String profileName;
    private static final String SESSION_RESOURCE = "_nosqlSESSPROXY_";

    SessionProxy(Object session, String profileName) {
        this.underlyingSession = session;
        this.profileName = profileName;
    }

    static Object getSessionFromJTATransaction(TransactionSynchronizationRegistry transactionSynchronizationRegistry, String profileName) {
        return transactionSynchronizationRegistry.getResource((Object)(SESSION_RESOURCE + profileName));
    }

    static Object registerSessionWithJTATransaction(Object underlyingSession, TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String profileName, String jndiName) {
        SessionProxy sessionProxy = new SessionProxy(underlyingSession, profileName);
        Object sessionProxyInstance = Proxy.newProxyInstance(underlyingSession.getClass().getClassLoader(), underlyingSession.getClass().getInterfaces(), (InvocationHandler)sessionProxy);
        TransactionControl transactionControl = sessionProxy.transactionControl();
        Neo4jXAResourceImpl resource = new Neo4jXAResourceImpl(transactionControl, jndiName, null, null);
        try {
            transactionManager.getTransaction().enlistResource((XAResource)((Object)resource));
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        transactionSynchronizationRegistry.putResource((Object)(SESSION_RESOURCE + profileName), sessionProxyInstance);
        return sessionProxyInstance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("beginTransaction")) {
            throw new RuntimeException("Incorrect use of JTA enlisted Session(" + this.profileName + "), application should use JTA to control the transaction instead of Session.beginTransaction");
        }
        if (method.getName().equals("close")) {
            return null;
        }
        if (this.underlyingTransaction == null) {
            if (method.getName().equals("isOpen")) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("no underlying Neo4j transaction to invoke '" + method.getName() + "' with.");
        }
        method = this.underlyingTransaction.getClass().getMethod(method.getName(), method.getParameterTypes());
        Object result = method.invoke(this.underlyingTransaction, args);
        return result;
    }

    private TransactionControl transactionControl() {
        return new TransactionControl(){

            @Override
            public Object beginTransaction() {
                try {
                    SessionProxy.this.underlyingTransaction = SessionProxy.this.underlyingSession.getClass().getMethod("beginTransaction", new Class[0]).invoke(SessionProxy.this.underlyingSession, null);
                    return SessionProxy.this.underlyingTransaction;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not begin transaction", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("could not begin transaction", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("could not begin transaction", e);
                }
            }

            @Override
            public void success() {
                try {
                    SessionProxy.this.underlyingTransaction.getClass().getMethod("success", new Class[0]).invoke(SessionProxy.this.underlyingTransaction, null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not mark transaction as successful", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("could not mark transaction as successful", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("could not mark transaction as successful", e);
                }
            }

            @Override
            public void failure() {
                try {
                    SessionProxy.this.underlyingTransaction.getClass().getMethod("failure", new Class[0]).invoke(SessionProxy.this.underlyingTransaction, null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not mark transaction as failed", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("could not mark transaction as failed", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("could not mark transaction as failed", e);
                }
            }

            @Override
            public void close() {
                try {
                    SessionProxy.this.underlyingTransaction.getClass().getMethod("close", new Class[0]).invoke(SessionProxy.this.underlyingTransaction, null);
                    SessionProxy.this.underlyingTransaction = null;
                    SessionProxy.this.underlyingSession.getClass().getMethod("close", new Class[0]).invoke(SessionProxy.this.underlyingSession, null);
                    SessionProxy.this.underlyingSession = null;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("could not close the transaction", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("could not close the transaction", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("could not close the transaction", e);
                }
            }
        };
    }
}

