/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.orient.core.id.ORID;

public class OConcurrentCreateException
extends ONeedRetryException
implements OHighLevelException {
    private static final long serialVersionUID = 1L;
    private ORID expectedRid;
    private ORID actualRid;

    public OConcurrentCreateException(OConcurrentCreateException exception) {
        super(exception);
        this.expectedRid = exception.expectedRid;
        this.actualRid = exception.actualRid;
    }

    protected OConcurrentCreateException(String message) {
        super(message);
    }

    public OConcurrentCreateException(ORID expectedRID, ORID actualRid) {
        super(OConcurrentCreateException.makeMessage(expectedRID, actualRid));
        this.expectedRid = expectedRID;
        this.actualRid = actualRid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OConcurrentCreateException)) {
            return false;
        }
        OConcurrentCreateException other = (OConcurrentCreateException)obj;
        return this.expectedRid.equals(other.expectedRid) && this.actualRid.equals(other.actualRid);
    }

    public ORID getExpectedRid() {
        return this.expectedRid;
    }

    public ORID getActualRid() {
        return this.actualRid;
    }

    private static String makeMessage(ORID expectedRid, ORID actualRid) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot create the record ");
        sb.append(expectedRid);
        sb.append(" because the assigned RID was ");
        sb.append(actualRid);
        sb.append(" instead");
        return sb.toString();
    }
}

