/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class OIndexOneValue
extends OIndexAbstract<OIdentifiable> {
    public OIndexOneValue(String name, String type, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, type, algorithm, valueContainerAlgorithm, metadata, version, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIdentifiable get(Object iKey) {
        iKey = this.getCollatingValue(iKey);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(iKey);
        }
        try {
            OIdentifiable oIdentifiable;
            this.acquireSharedLock();
            try {
                oIdentifiable = (OIdentifiable)this.storage.getIndexValue(this.indexId, iKey);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oIdentifiable;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(iKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object iKey) {
        iKey = this.getCollatingValue(iKey);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(iKey);
        }
        try {
            long l;
            this.acquireSharedLock();
            try {
                l = this.storage.indexContainsKey(this.indexId, iKey) ? 1L : 0L;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(iKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument checkEntry(OIdentifiable record, Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            OIdentifiable indexedRID = this.get(key);
            if (indexedRID != null && !indexedRID.getIdentity().equals(record.getIdentity())) {
                Boolean mergeSameKey = this.metadata != null && (Boolean)this.metadata.field("mergeKeys") != false;
                if (mergeSameKey != null && mergeSameKey.booleanValue()) {
                    ODocument oDocument = (ODocument)indexedRID.getRecord();
                    return oDocument;
                }
                throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", record, key, this.getName(), indexedRID), this.getName(), indexedRID.getIdentity());
            }
            ODocument oDocument = null;
            return oDocument;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    public OIndexOneValue create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexOneValue)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        final ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            {
                this.keysIterator = sortedKeys.iterator();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                OIdentifiable result = null;
                Object key = null;
                while (this.keysIterator.hasNext() && result == null) {
                    key = this.keysIterator.next();
                    key = OIndexOneValue.this.getCollatingValue(key);
                    OIndexOneValue.this.acquireSharedLock();
                    try {
                        result = (OIdentifiable)OIndexOneValue.this.storage.getIndexValue(OIndexOneValue.this.indexId, key);
                    }
                    finally {
                        OIndexOneValue.this.releaseSharedLock();
                    }
                }
                if (result == null) {
                    return null;
                }
                final Object resultKey = key;
                final OIdentifiable resultValue = result;
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return resultKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getSize() {
        this.acquireSharedLock();
        try {
            long l = this.storage.getIndexSize(this.indexId, null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.acquireSharedLock();
        try {
            long l = this.storage.getIndexSize(this.indexId, null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.getIndexCursor(this.indexId, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.storage.getIndexDescCursor(this.indexId, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    protected OBinarySerializer determineValueSerializer() {
        return OStreamSerializerRID.INSTANCE;
    }
}

