/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OIndexRemote<T>
implements OIndex<T> {
    public static final String QUERY_GET_VALUES_BEETWEN_SELECT = "select from index:%s where ";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION = "key >= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION = "key > ?";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION = "key <= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION = "key < ?";
    public static final String QUERY_GET_VALUES_AND_OPERATOR = " and ";
    public static final String QUERY_GET_VALUES_LIMIT = " limit ";
    protected static final String QUERY_ENTRIES = "select key, rid from index:%s";
    protected static final String QUERY_ENTRIES_DESC = "select key, rid from index:%s order by key desc";
    private static final String QUERY_GET_ENTRIES = "select from index:%s where key in [%s]";
    private static final String QUERY_PUT = "insert into index:%s (key,rid) values (?,?)";
    private static final String QUERY_REMOVE = "delete from index:%s where key = ?";
    private static final String QUERY_REMOVE2 = "delete from index:%s where key = ? and rid = ?";
    private static final String QUERY_REMOVE3 = "delete from index:%s where rid = ?";
    private static final String QUERY_CONTAINS = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT_RANGE = "select count(*) as size from index:%s where ";
    private static final String QUERY_SIZE = "select count(*) as size from index:%s";
    private static final String QUERY_KEY_SIZE = "select count(distinct( key )) as size from index:%s";
    private static final String QUERY_KEYS = "select key from index:%s";
    private static final String QUERY_REBUILD = "rebuild index %s";
    private static final String QUERY_CLEAR = "delete from index:%s";
    private static final String QUERY_DROP = "drop index %s";
    protected final String databaseName;
    private final String wrappedType;
    private final String algorithm;
    private final ORID rid;
    protected OIndexDefinition indexDefinition;
    protected String name;
    protected ODocument configuration;
    protected Set<String> clustersToIndex;

    public OIndexRemote(String iName, String iWrappedType, String algorithm, ORID iRid, OIndexDefinition iIndexDefinition, ODocument iConfiguration, Set<String> clustersToIndex) {
        this.name = iName;
        this.wrappedType = iWrappedType;
        this.algorithm = algorithm;
        this.rid = iRid;
        this.indexDefinition = iIndexDefinition;
        this.configuration = iConfiguration;
        this.clustersToIndex = new HashSet<String>(clustersToIndex);
        this.databaseName = ODatabaseRecordThreadLocal.INSTANCE.get().getName();
    }

    @Override
    public OIndexRemote<T> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        this.name = name;
        return this;
    }

    @Override
    public OIndexRemote<T> delete() {
        OCommandRequest cmd = this.formatCommand(QUERY_DROP, this.name);
        this.getDatabase().command(cmd).execute(new Object[0]);
        return this;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public long getRebuildVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object iKey) {
        OCommandRequest cmd = this.formatCommand("select count(*) as size from index:%s where key = ?", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(iKey);
        return (Long)((ODocument)result.get(0)).field("size") > 0L;
    }

    @Override
    public long count(Object iKey) {
        OCommandRequest cmd = this.formatCommand("select count(*) as size from index:%s where key = ?", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(iKey);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    public long count(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        StringBuilder query = new StringBuilder(QUERY_COUNT_RANGE);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        if (maxValuesToFetch > 0) {
            query.append(QUERY_GET_VALUES_LIMIT).append(maxValuesToFetch);
        }
        OCommandRequest cmd = this.formatCommand(query.toString(), new Object[0]);
        return (Long)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public OIndexRemote<T> put(Object iKey, OIdentifiable iValue) {
        if (iValue instanceof ORecord && !iValue.getIdentity().isValid()) {
            ((ORecord)iValue).save();
        }
        if (iValue.getIdentity().isNew()) {
            throw new OIndexException("Cannot insert values in manual indexes against remote protocol during a transaction. Temporary RID cannot be managed at server side");
        }
        OCommandRequest cmd = this.formatCommand(QUERY_PUT, this.name);
        this.getDatabase().command(cmd).execute(iKey, iValue.getIdentity());
        return this;
    }

    @Override
    public boolean remove(Object key) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name);
        return (Integer)this.getDatabase().command(cmd).execute(key) > 0;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        int deleted;
        if (iRID != null) {
            if (iRID.getIdentity().isNew()) {
                throw new OIndexException("Cannot remove values in manual indexes against remote protocol during a transaction. Temporary RID cannot be managed at server side");
            }
            OCommandRequest cmd = this.formatCommand(QUERY_REMOVE2, this.name);
            deleted = (Integer)this.getDatabase().command(cmd).execute(iKey, iRID);
        } else {
            OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name);
            deleted = (Integer)this.getDatabase().command(cmd).execute(iKey);
        }
        return deleted > 0;
    }

    public int remove(OIdentifiable iRecord) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE3, this.name, iRecord.getIdentity());
        return (Integer)this.getDatabase().command(cmd).execute(iRecord);
    }

    public void automaticRebuild() {
        throw new UnsupportedOperationException("autoRebuild()");
    }

    @Override
    public long rebuild() {
        OCommandRequest cmd = this.formatCommand(QUERY_REBUILD, this.name);
        return (Long)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public OIndexRemote<T> clear() {
        OCommandRequest cmd = this.formatCommand(QUERY_CLEAR, this.name);
        this.getDatabase().command(cmd).execute(new Object[0]);
        return this;
    }

    @Override
    public long getSize() {
        OCommandRequest cmd = this.formatCommand(QUERY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public long getKeySize() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public boolean isAutomatic() {
        return this.indexDefinition != null && this.indexDefinition.getClassName() != null;
    }

    @Override
    public int getVersion() {
        if (this.configuration == null) {
            return -1;
        }
        return (Integer)this.configuration.field("indexVersion");
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
    }

    @Override
    public String getType() {
        return this.wrappedType;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration;
    }

    @Override
    public ODocument getMetadata() {
        return (ODocument)this.configuration.field("metadata", OType.EMBEDDED);
    }

    public ORID getIdentity() {
        return this.rid;
    }

    public void commit(ODocument iDocument) {
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return null;
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.rebuild();
    }

    @Override
    public OType[] getKeyTypes() {
        if (this.indexDefinition != null) {
            return this.indexDefinition.getTypes();
        }
        return new OType[0];
    }

    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder(128);
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_ENTRIES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexRemote that = (OIndexRemote)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntries(iKeys);
        }
        StringBuilder params = new StringBuilder(128);
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand("select from index:%s where key in [%s] limit " + maxEntriesToFetch, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Set<String> getClusters() {
        return Collections.unmodifiableSet(this.clustersToIndex);
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        return null;
    }

    @Override
    public boolean isRebuilding() {
        return false;
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("getFirstKey");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("getLastKey");
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        throw new UnsupportedOperationException("iterateEntries");
    }

    @Override
    public int getIndexId() {
        throw new UnsupportedOperationException("getIndexId");
    }

    @Override
    public OIndexCursor cursor() {
        OCommandRequest cmd = this.formatCommand(QUERY_ENTRIES, this.name);
        final Collection result = (Collection)this.getDatabase().command(cmd).execute(new Object[0]);
        return new OIndexAbstractCursor(){
            private final Iterator<ODocument> documentIterator;
            {
                this.documentIterator = result.iterator();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (!this.documentIterator.hasNext()) {
                    return null;
                }
                final ODocument value = this.documentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return value.field("key");
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return (OIdentifiable)value.field("rid");
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value2) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public OIndexCursor descCursor() {
        OCommandRequest cmd = this.formatCommand(QUERY_ENTRIES_DESC, this.name);
        final Collection result = (Collection)this.getDatabase().command(cmd).execute(new Object[0]);
        return new OIndexAbstractCursor(){
            private final Iterator<ODocument> documentIterator;
            {
                this.documentIterator = result.iterator();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (!this.documentIterator.hasNext()) {
                    return null;
                }
                final ODocument value = this.documentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return value.field("key");
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return (OIdentifiable)value.field("rid");
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value2) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEYS, this.name);
        final Collection result = (Collection)this.getDatabase().command(cmd).execute(new Object[0]);
        return new OIndexKeyCursor(){
            private final Iterator<ODocument> documentIterator;
            {
                this.documentIterator = result.iterator();
            }

            @Override
            public Object next(int prefetchSize) {
                if (!this.documentIterator.hasNext()) {
                    return null;
                }
                ODocument value = this.documentIterator.next();
                return value.field("key");
            }
        };
    }

    @Override
    public int compareTo(OIndex<T> index) {
        String name = index.getName();
        return this.name.compareTo(name);
    }

    protected OCommandRequest formatCommand(String iTemplate, Object ... iArgs) {
        String text = String.format(iTemplate, iArgs);
        return new OCommandSQL(text);
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

