/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.DelegatingResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerServiceInitialization;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLoggerImpl;
import org.jboss.as.controller.capability.registry.ImmutableCapabilityRegistry;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.HostConnectionInfo;
import org.jboss.as.domain.controller.HostRegistrations;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.ApplyExtensionsHandler;
import org.jboss.as.domain.controller.operations.DomainModelIncludesValidator;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.controller.resources.DomainRootDefinition;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.host.controller.DiscoveryService;
import org.jboss.as.host.controller.DomainSlaveHostRegistrations;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerEnvironmentService;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.RemoteDomainConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.ServerInventoryCallbackService;
import org.jboss.as.host.controller.ServerInventoryService;
import org.jboss.as.host.controller.SystemExiter;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DomainControllerManagementInterface;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainHostExcludeRegistry;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerService;
import org.jboss.as.host.controller.mgmt.ServerToHostOperationHandlerFactoryService;
import org.jboss.as.host.controller.mgmt.ServerToHostProtocolHandler;
import org.jboss.as.host.controller.mgmt.SlaveHostPinger;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.LocalFileRepository;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.RuntimeExpressionResolver;
import org.jboss.as.server.controller.resources.VersionModelInitializer;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DomainModelControllerService
extends AbstractControllerService
implements DomainController,
HostModelUtil.HostModelRegistrar,
HostRegistrations {
    public static final ServiceName SERVICE_NAME = HostControllerService.HC_SERVICE_NAME.append(new String[]{"model", "controller"});
    private static final int PINGER_POOL_SIZE;
    private volatile HostControllerConfigurationPersister hostControllerConfigurationPersister;
    private final HostControllerEnvironment environment;
    private final HostRunningModeControl runningModeControl;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostFileRepository localFileRepository;
    private final RemoteDomainConnectionService.RemoteFileRepository remoteFileRepository;
    private final InjectedValue<ProcessControllerConnectionService> injectedProcessControllerConnection = new InjectedValue();
    private final ConcurrentMap<String, ProxyController> hostProxies;
    private final DomainSlaveHostRegistrations slaveHostRegistrations = new DomainSlaveHostRegistrations();
    private final Map<String, ProxyController> serverProxies;
    private final PrepareStepHandler prepareStepHandler;
    private final BootstrapListener bootstrapListener;
    private ManagementResourceRegistration modelNodeRegistration;
    private final AbstractVaultReader vaultReader;
    private final ContentRepository contentRepository;
    private final ExtensionRegistry hostExtensionRegistry;
    private final ExtensionRegistry extensionRegistry;
    private final ControlledProcessState processState;
    private final IgnoredDomainResourceRegistry ignoredRegistry;
    private final PathManagerService pathManager;
    private final ExpressionResolver expressionResolver;
    private final DomainDelegatingResourceDefinition rootResourceDefinition;
    private final CapabilityRegistry capabilityRegistry;
    private final DomainHostExcludeRegistry domainHostExcludeRegistry;
    private final AtomicBoolean domainModelComplete = new AtomicBoolean(false);
    private final AbstractControllerService.PartialModelIndicator partialModelIndicator = new AbstractControllerService.PartialModelIndicator(){

        public boolean isModelPartial() {
            return !DomainModelControllerService.this.domainModelComplete.get();
        }
    };
    private Future<ServerInventory> inventoryFuture;
    private final AtomicBoolean serverInventoryLock = new AtomicBoolean();
    private volatile ServerInventory serverInventory;
    private volatile ScheduledExecutorService pingScheduler;
    private volatile ManagementResourceRegistration hostModelRegistration;

    static ServiceController<ModelController> addService(ServiceTarget serviceTarget, HostControllerEnvironment environment, HostRunningModeControl runningModeControl, ControlledProcessState processState, BootstrapListener bootstrapListener, PathManagerService pathManager) {
        ConcurrentHashMap<String, ProxyController> hostProxies = new ConcurrentHashMap<String, ProxyController>();
        ConcurrentHashMap<String, ProxyController> serverProxies = new ConcurrentHashMap<String, ProxyController>();
        LocalHostControllerInfoImpl hostControllerInfo = new LocalHostControllerInfoImpl(processState, environment);
        AbstractVaultReader vaultReader = DomainModelControllerService.loadVaultReaderService();
        HostControllerLogger.ROOT_LOGGER.debugf("Using VaultReader %s", vaultReader);
        ContentRepository contentRepository = ContentRepository.Factory.create((File)environment.getDomainContentDir());
        IgnoredDomainResourceRegistry ignoredRegistry = new IgnoredDomainResourceRegistry(hostControllerInfo);
        ManagedAuditLogger auditLogger = DomainModelControllerService.createAuditLogger(environment);
        DelegatingConfigurableAuthorizer authorizer = new DelegatingConfigurableAuthorizer();
        DomainHostControllerInfoAccessor hostControllerInfoAccessor = new DomainHostControllerInfoAccessor(hostControllerInfo);
        ProcessType processType = environment.getProcessType();
        ExtensionRegistry hostExtensionRegistry = new ExtensionRegistry(processType, (RunningModeControl)runningModeControl, auditLogger, (JmxAuthorizer)authorizer, (RuntimeHostControllerInfoAccessor)hostControllerInfoAccessor);
        ExtensionRegistry extensionRegistry = new ExtensionRegistry(processType, (RunningModeControl)runningModeControl, auditLogger, (JmxAuthorizer)authorizer, (RuntimeHostControllerInfoAccessor)hostControllerInfoAccessor);
        CapabilityRegistry capabilityRegistry = new CapabilityRegistry(processType.isServer());
        PrepareStepHandler prepareStepHandler = new PrepareStepHandler(hostControllerInfo, hostProxies, serverProxies, ignoredRegistry, extensionRegistry);
        RuntimeExpressionResolver expressionResolver = new RuntimeExpressionResolver((VaultReader)vaultReader);
        DomainHostExcludeRegistry domainHostExcludeRegistry = new DomainHostExcludeRegistry();
        DomainModelControllerService service = new DomainModelControllerService(environment, runningModeControl, processState, hostControllerInfo, contentRepository, hostProxies, serverProxies, prepareStepHandler, vaultReader, ignoredRegistry, bootstrapListener, pathManager, (ExpressionResolver)expressionResolver, new DomainDelegatingResourceDefinition(), hostExtensionRegistry, extensionRegistry, auditLogger, authorizer, capabilityRegistry, domainHostExcludeRegistry);
        HostControllerEnvironmentService.addService(environment, serviceTarget);
        return serviceTarget.addService(SERVICE_NAME, (Service)service).addDependency(HostControllerService.HC_EXECUTOR_SERVICE_NAME, ExecutorService.class, (Injector)service.getExecutorServiceInjector()).addDependency(ProcessControllerConnectionService.SERVICE_NAME, ProcessControllerConnectionService.class, service.injectedProcessControllerConnection).addDependency(PathManagerService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private DomainModelControllerService(HostControllerEnvironment environment, HostRunningModeControl runningModeControl, ControlledProcessState processState, LocalHostControllerInfoImpl hostControllerInfo, ContentRepository contentRepository, ConcurrentMap<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, PrepareStepHandler prepareStepHandler, AbstractVaultReader vaultReader, IgnoredDomainResourceRegistry ignoredRegistry, BootstrapListener bootstrapListener, PathManagerService pathManager, ExpressionResolver expressionResolver, DomainDelegatingResourceDefinition rootResourceDefinition, ExtensionRegistry hostExtensionRegistry, ExtensionRegistry extensionRegistry, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, CapabilityRegistry capabilityRegistry, DomainHostExcludeRegistry domainHostExcludeRegistry) {
        super(environment.getProcessType(), (RunningModeControl)runningModeControl, null, processState, (ResourceDefinition)rootResourceDefinition, (OperationStepHandler)prepareStepHandler, (ExpressionResolver)new RuntimeExpressionResolver((VaultReader)vaultReader), auditLogger, authorizer, capabilityRegistry);
        this.environment = environment;
        this.runningModeControl = runningModeControl;
        this.processState = processState;
        this.hostControllerInfo = hostControllerInfo;
        this.localFileRepository = new LocalFileRepository(environment.getDomainBaseDir(), environment.getDomainContentDir(), environment.getDomainConfigurationDir());
        this.remoteFileRepository = new RemoteDomainConnectionService.RemoteFileRepository(this.localFileRepository);
        this.contentRepository = contentRepository;
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.prepareStepHandler = prepareStepHandler;
        this.vaultReader = vaultReader;
        this.ignoredRegistry = ignoredRegistry;
        this.bootstrapListener = bootstrapListener;
        this.hostExtensionRegistry = hostExtensionRegistry;
        this.extensionRegistry = extensionRegistry;
        this.pathManager = pathManager;
        this.expressionResolver = expressionResolver;
        this.rootResourceDefinition = rootResourceDefinition;
        this.capabilityRegistry = capabilityRegistry;
        this.domainHostExcludeRegistry = domainHostExcludeRegistry;
    }

    private static ManagedAuditLogger createAuditLogger(HostControllerEnvironment environment) {
        return new ManagedAuditLoggerImpl(environment.getProductConfig().resolveVersion(), false);
    }

    @Override
    public RunningMode getCurrentRunningMode() {
        return this.runningModeControl.getRunningMode();
    }

    @Override
    public LocalHostControllerInfo getLocalHostInfo() {
        return this.hostControllerInfo;
    }

    @Override
    public void registerRemoteHost(String hostName, ManagementChannelHandler handler, Transformers transformers, Long remoteConnectionId, boolean registerProxyController) throws SlaveRegistrationException {
        if (!this.hostControllerInfo.isMasterDomainController()) {
            throw SlaveRegistrationException.forHostIsNotMaster();
        }
        if (this.runningModeControl.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw SlaveRegistrationException.forMasterInAdminOnlyMode(this.runningModeControl.getRunningMode());
        }
        PathElement pe = PathElement.pathElement((String)"host", (String)hostName);
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{pe});
        ProxyController existingController = this.modelNodeRegistration.getProxyController(addr);
        if (existingController != null || this.hostControllerInfo.getLocalHostName().equals(pe.getValue())) {
            throw SlaveRegistrationException.forHostAlreadyExists(pe.getValue());
        }
        SlaveHostPinger pinger = remoteConnectionId == null ? null : new SlaveHostPinger(hostName, handler, this.pingScheduler, remoteConnectionId);
        String address = handler.getRemoteAddress().getHostAddress();
        this.slaveHostRegistrations.registerHost(hostName, pinger, address);
        if (registerProxyController) {
            TransformingProxyController hostControllerClient = TransformingProxyController.Factory.create((ManagementChannelHandler)handler, (Transformers)transformers, (PathAddress)addr, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.HOST);
            this.modelNodeRegistration.registerProxyController(pe, (ProxyController)hostControllerClient);
            this.hostProxies.put(hostName, (ProxyController)hostControllerClient);
        }
    }

    @Override
    public boolean isHostRegistered(String id) {
        DomainSlaveHostRegistrations.DomainHostConnection registration = this.slaveHostRegistrations.getRegistration(id);
        return registration != null && registration.isConnected();
    }

    @Override
    public void unregisterRemoteHost(String id, Long remoteConnectionId, boolean cleanShutdown) {
        DomainSlaveHostRegistrations.DomainHostConnection hostRegistration = this.slaveHostRegistrations.getRegistration(id);
        if (hostRegistration != null && (remoteConnectionId == null || remoteConnectionId.equals(hostRegistration.getRemoteConnectionId()))) {
            SlaveHostPinger pinger = hostRegistration.getPinger();
            if (pinger != null) {
                pinger.cancel();
            }
            boolean registered = this.hostProxies.remove(id) != null;
            this.modelNodeRegistration.unregisterProxyController(PathElement.pathElement((String)"host", (String)id));
            if (registered) {
                String address = hostRegistration.getAddress();
                HostConnectionInfo.Event event = cleanShutdown ? HostConnectionInfo.Events.create(HostConnectionInfo.EventType.UNREGISTERED, address) : HostConnectionInfo.Events.create(HostConnectionInfo.EventType.UNCLEAN_UNREGISTRATION, address);
                this.slaveHostRegistrations.unregisterHost(id, event);
                if (!cleanShutdown) {
                    HostControllerLogger.DOMAIN_LOGGER.lostConnectionToRemoteHost(id);
                } else {
                    HostControllerLogger.DOMAIN_LOGGER.unregisteredRemoteSlaveHost(id);
                }
            }
        }
    }

    @Override
    public void addHostEvent(String hostName, HostConnectionInfo.Event event) {
        this.slaveHostRegistrations.addEvent(hostName, event);
    }

    @Override
    public void pruneExpired() {
        this.slaveHostRegistrations.pruneExpired();
    }

    @Override
    public void pruneDisconnected() {
        this.slaveHostRegistrations.pruneDisconnected();
    }

    @Override
    public HostConnectionInfo getHostInfo(String hostName) {
        return this.slaveHostRegistrations.getRegistration(hostName);
    }

    @Override
    public void pingRemoteHost(String id) {
        DomainSlaveHostRegistrations.DomainHostConnection reg = this.slaveHostRegistrations.getRegistration(id);
        if (reg != null && reg.getPinger() != null && !reg.getPinger().isCancelled()) {
            reg.getPinger().schedulePing(10000L, 0L);
        }
    }

    @Override
    public void registerRunningServer(ProxyController serverControllerClient) {
        PathAddress pa = serverControllerClient.getProxyNodeAddress();
        PathElement pe = pa.getElement(1);
        if (this.modelNodeRegistration.getProxyController(pa) != null) {
            throw HostControllerLogger.ROOT_LOGGER.serverNameAlreadyRegistered(pe.getValue());
        }
        HostControllerLogger.ROOT_LOGGER.registeringServer(pe.getValue());
        ManagementResourceRegistration hostRegistration = this.modelNodeRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostControllerInfo.getLocalHostName())}));
        hostRegistration.registerProxyController(pe, serverControllerClient);
        ManagementResourceRegistration serverRegistration = hostRegistration.getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{pe}));
        ServerConfigResourceDefinition.registerServerLifecycleOperations(serverRegistration, this.serverInventory);
        this.serverProxies.put(pe.getValue(), serverControllerClient);
    }

    @Override
    public void unregisterRunningServer(String serverName) {
        PathAddress pa = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostControllerInfo.getLocalHostName())});
        PathElement pe = PathElement.pathElement((String)"server", (String)serverName);
        HostControllerLogger.ROOT_LOGGER.unregisteringServer(serverName);
        ManagementResourceRegistration hostRegistration = this.modelNodeRegistration.getSubModel(pa);
        hostRegistration.unregisterProxyController(pe);
        this.serverProxies.remove(serverName);
    }

    @Override
    public ModelNode getProfileOperations(String profileName) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("describe");
        operation.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"profile", (String)profileName)}).toModelNode());
        operation.get("server-launch").set(true);
        ModelNode rsp = this.getValue().execute(operation, null, null, null);
        if (!rsp.hasDefined("outcome") || !"success".equals(rsp.get("outcome").asString())) {
            ModelNode msgNode = rsp.get("failure-description");
            String msg = msgNode.isDefined() ? msgNode.toString() : HostControllerLogger.ROOT_LOGGER.failedProfileOperationsRetrieval();
            throw new RuntimeException(msg);
        }
        return rsp.require("result");
    }

    @Override
    public HostFileRepository getLocalFileRepository() {
        return this.localFileRepository;
    }

    @Override
    public HostFileRepository getRemoteFileRepository() {
        if (this.hostControllerInfo.isMasterDomainController()) {
            throw HostControllerLogger.ROOT_LOGGER.cannotAccessRemoteFileRepository();
        }
        return this.remoteFileRepository;
    }

    public void start(StartContext context) throws StartException {
        ExecutorService executorService = (ExecutorService)this.getExecutorServiceInjector().getValue();
        this.hostControllerConfigurationPersister = new HostControllerConfigurationPersister(this.environment, this.hostControllerInfo, executorService, this.hostExtensionRegistry, this.extensionRegistry);
        this.setConfigurationPersister((ConfigurationPersister)this.hostControllerConfigurationPersister);
        this.prepareStepHandler.setExecutorService(executorService);
        ThreadFactory pingerThreadFactory = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup("proxy-pinger-threads"), Boolean.TRUE, null, "%G - %t", null, null);
            }
        });
        this.pingScheduler = Executors.newScheduledThreadPool(PINGER_POOL_SIZE, pingerThreadFactory);
        super.start(context);
        this.pingScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DomainModelControllerService.this.slaveHostRegistrations.pruneExpired();
                }
                catch (Exception e) {
                    HostControllerLogger.DOMAIN_LOGGER.debugf(e, "failed to execute eviction task", new Object[0]);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    protected void initModel(ManagementModel managementModel, Resource modelControllerResource) {
        HostModelUtil.createRootRegistry(managementModel.getRootResourceRegistration(), this.environment, this.ignoredRegistry, this, this.processType, this.authorizer, modelControllerResource);
        VersionModelInitializer.registerRootResource((Resource)managementModel.getRootResource(), this.environment != null ? this.environment.getProductConfig() : null);
        CoreManagementResourceDefinition.registerDomainResource((Resource)managementModel.getRootResource(), (AccessConstraintUtilizationRegistry)this.authorizer.getWritableAuthorizerConfiguration());
        this.modelNodeRegistration = managementModel.getRootResourceRegistration();
        ResourceProvider.Tool.addResourceProvider((String)"host-connection", (ResourceProvider)new ResourceProvider(){

            public boolean has(String name) {
                return DomainModelControllerService.this.slaveHostRegistrations.contains(name);
            }

            public Resource get(String name) {
                return PlaceholderResource.INSTANCE;
            }

            public boolean hasChildren() {
                return true;
            }

            public Set<String> children() {
                return DomainModelControllerService.this.slaveHostRegistrations.getHosts();
            }

            public void register(String name, Resource resource) {
                throw new UnsupportedOperationException();
            }

            public void register(String value, int index, Resource resource) {
            }

            public Resource remove(String name) {
                throw new UnsupportedOperationException();
            }

            public ResourceProvider clone() {
                return this;
            }
        }, (Resource)managementModel.getRootResource().getChild(CoreManagementResourceDefinition.PATH_ELEMENT));
    }

    protected OperationStepHandler createExtraValidationStepHandler() {
        return new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress addr;
                if (!context.isBooting() && (addr = context.getCurrentAddress()).size() > 0 && addr.getLastElement().getKey().equals("subsystem")) {
                    DomainModelIncludesValidator.addValidationStep(context, operation);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean ok = false;
        boolean reachedServers = false;
        try {
            ServerInventoryCallbackService.install(serviceTarget);
            List<ModelNode> hostBootOps = this.hostControllerConfigurationPersister.load();
            ModelNode addHostOp = hostBootOps.remove(0);
            HostControllerLogger.ROOT_LOGGER.debug("Invoking the initial add-host op");
            ok = this.boot(Collections.singletonList(addHostOp), true, true);
            hostBootOps.add(this.registerModelControllerServiceInitializationBootStep(context));
            if (ok) {
                HostControllerLogger.ROOT_LOGGER.debug("Invoking remaining host.xml ops");
                ok = this.boot(hostBootOps, true, true, new MutableRootResourceRegistrationProvider(){

                    public ManagementResourceRegistration getRootResourceRegistrationForUpdate(OperationContext context) {
                        return DomainModelControllerService.this.hostModelRegistration;
                    }
                });
            }
            RunningMode currentRunningMode = this.runningModeControl.getRunningMode();
            if (ok) {
                Future<ServerInventory> inventoryFuture = this.installServerInventory(serviceTarget);
                List<DiscoveryOption> discoveryOptions = this.hostControllerInfo.getRemoteDomainControllerDiscoveryOptions();
                if (this.hostControllerInfo.isMasterDomainController() && discoveryOptions != null) {
                    this.installDiscoveryService(serviceTarget, discoveryOptions);
                }
                if (!this.hostControllerInfo.isMasterDomainController() && !this.environment.isUseCachedDc()) {
                    boolean discoveryConfigured;
                    this.establishServerInventory(inventoryFuture);
                    boolean bl = discoveryConfigured = discoveryOptions != null && !discoveryOptions.isEmpty();
                    if (currentRunningMode != RunningMode.ADMIN_ONLY) {
                        if (discoveryConfigured) {
                            this.connectToDomainMaster(serviceTarget, currentRunningMode);
                        } else {
                            HostControllerLogger.ROOT_LOGGER.noDomainControllerConfigurationProvided(currentRunningMode, "--admin-only", RunningMode.ADMIN_ONLY);
                            SystemExiter.abort(99);
                        }
                    } else {
                        switch (this.hostControllerInfo.getAdminOnlyDomainConfigPolicy()) {
                            case ALLOW_NO_CONFIG: {
                                break;
                            }
                            case FETCH_FROM_MASTER: {
                                if (discoveryConfigured) {
                                    this.connectToDomainMaster(serviceTarget, currentRunningMode);
                                    break;
                                }
                                HostControllerLogger.ROOT_LOGGER.noDomainControllerConfigurationProvidedForAdminOnly("admin-only-policy", AdminOnlyDomainConfigPolicy.REQUIRE_LOCAL_CONFIG, "--cached-dc", RunningMode.ADMIN_ONLY);
                                SystemExiter.abort(99);
                                break;
                            }
                            case REQUIRE_LOCAL_CONFIG: {
                                HostControllerLogger.ROOT_LOGGER.noAccessControlConfigurationAvailable(currentRunningMode, "admin-only-policy", AdminOnlyDomainConfigPolicy.REQUIRE_LOCAL_CONFIG, "--cached-dc", currentRunningMode);
                                SystemExiter.abort(99);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(this.hostControllerInfo.getAdminOnlyDomainConfigPolicy().toString());
                            }
                        }
                    }
                } else {
                    if (this.environment.isUseCachedDc()) {
                        HostControllerLogger.ROOT_LOGGER.usingCachedDC("--cached-dc", "domain.cached-remote.xml");
                        this.remoteFileRepository.setRemoteFileRepositoryExecutor(new RemoteDomainConnectionService.RemoteFileRepositoryExecutor(){

                            @Override
                            public File getFile(String relativePath, byte repoId, HostFileRepository localFileRepository) {
                                return localFileRepository.getFile(relativePath);
                            }
                        });
                    }
                    ExtensibleConfigurationPersister domainPersister = this.hostControllerConfigurationPersister.getDomainPersister();
                    List domainBootOps = domainPersister.load();
                    HostControllerLogger.ROOT_LOGGER.debug("Invoking domain.xml ops");
                    ok = this.boot(domainBootOps, false);
                    this.domainModelComplete.set(ok);
                    if (!ok && this.runningModeControl.getRunningMode().equals((Object)RunningMode.ADMIN_ONLY)) {
                        HostControllerLogger.ROOT_LOGGER.reportAdminOnlyDomainXmlFailure();
                        ok = true;
                    }
                    if (ok && this.processType != ProcessType.EMBEDDED_HOST_CONTROLLER) {
                        InternalExecutor executor = new InternalExecutor();
                        ManagementRemotingServices.installManagementChannelServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (AbstractModelControllerOperationHandlerFactoryService)new MasterDomainControllerOperationHandlerService(this, executor, executor, this.environment.getDomainTempDir(), this, this.domainHostExcludeRegistry), (ServiceName)SERVICE_NAME, (String)"domain", (ServiceName)HostControllerService.HC_EXECUTOR_SERVICE_NAME, (ServiceName)HostControllerService.HC_SCHEDULED_EXECUTOR_SERVICE_NAME);
                        this.establishServerInventory(inventoryFuture);
                    }
                    String hostName = this.hostControllerInfo.getLocalHostName();
                    this.slaveHostRegistrations.registerHost(hostName, null, "local");
                }
            }
            if (ok && this.hostControllerInfo.getAdminOnlyDomainConfigPolicy() != AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG) {
                ModelNode validate = new ModelNode();
                validate.get("operation").set("validate");
                validate.get("address").setEmptyList();
                ModelNode result = this.internalExecute(OperationBuilder.create((ModelNode)validate).build(), OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        DomainModelIncludesValidator.validateAtBoot(context, operation);
                    }
                }).getResponseNode();
                if (!"success".equals(result.get("outcome").asString())) {
                    throw new OperationFailedException(result.get("failure-description"));
                }
            }
            if (ok && this.processType != ProcessType.EMBEDDED_HOST_CONTROLLER) {
                ServerToHostOperationHandlerFactoryService.install(serviceTarget, ServerInventoryService.SERVICE_NAME, (ExecutorService)this.getExecutorServiceInjector().getValue(), new InternalExecutor(), this, this.expressionResolver, this.environment.getDomainTempDir());
                serviceTarget.addService(ServiceName.JBOSS.append(new String[]{"native-mgmt-startup"}), Service.NULL).addDependency(ManagementRemotingServices.channelServiceName((ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (String)"server")).setInitialMode(ServiceController.Mode.ACTIVE).install();
                serviceTarget.addService(ServiceName.JBOSS.append(new String[]{"http-mgmt-startup"}), Service.NULL).addDependency(ServiceBuilder.DependencyType.OPTIONAL, UndertowHttpManagementService.SERVICE_NAME).setInitialMode(ServiceController.Mode.ACTIVE).install();
                reachedServers = true;
                if (currentRunningMode == RunningMode.NORMAL) {
                    this.startServers();
                }
            }
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.caughtExceptionDuringBoot(e);
            if (!reachedServers) {
                ok = false;
            }
        }
        finally {
            if (ok) {
                try {
                    this.finishBoot();
                }
                finally {
                    this.bootstrapListener.printBootStatistics();
                }
            } else {
                String failed = HostControllerLogger.ROOT_LOGGER.unsuccessfulBoot();
                HostControllerLogger.ROOT_LOGGER.fatal(failed);
                this.bootstrapListener.bootFailure(failed);
                if (this.processType != ProcessType.EMBEDDED_HOST_CONTROLLER) {
                    SystemExiter.abort(99);
                }
            }
        }
    }

    protected final AbstractControllerService.PartialModelIndicator getPartialModelIndicator() {
        return this.partialModelIndicator;
    }

    private Future<ServerInventory> installServerInventory(ServiceTarget serviceTarget) {
        if (this.hostControllerInfo.getHttpManagementSecureInterface() != null && !this.hostControllerInfo.getHttpManagementSecureInterface().isEmpty() && this.hostControllerInfo.getHttpManagementSecurePort() > 0) {
            return ServerInventoryService.install(serviceTarget, this, this.runningModeControl, this.environment, this.extensionRegistry, this.hostControllerInfo.getHttpManagementSecureInterface(), this.hostControllerInfo.getHttpManagementSecurePort(), Protocol.HTTPS_REMOTING.toString());
        }
        if (this.hostControllerInfo.getNativeManagementInterface() != null && !this.hostControllerInfo.getNativeManagementInterface().isEmpty() && this.hostControllerInfo.getNativeManagementPort() > 0) {
            return ServerInventoryService.install(serviceTarget, this, this.runningModeControl, this.environment, this.extensionRegistry, this.hostControllerInfo.getNativeManagementInterface(), this.hostControllerInfo.getNativeManagementPort(), Protocol.REMOTE.toString());
        }
        if (this.processType == ProcessType.EMBEDDED_HOST_CONTROLLER) {
            return this.getPlaceHolderInventory();
        }
        return ServerInventoryService.install(serviceTarget, this, this.runningModeControl, this.environment, this.extensionRegistry, this.hostControllerInfo.getHttpManagementInterface(), this.hostControllerInfo.getHttpManagementPort(), Protocol.HTTP_REMOTING.toString());
    }

    private void installDiscoveryService(ServiceTarget serviceTarget, List<DiscoveryOption> discoveryOptions) {
        ArrayList<DomainControllerManagementInterface> interfaces = new ArrayList<DomainControllerManagementInterface>();
        if (this.hostControllerInfo.getNativeManagementInterface() != null && !this.hostControllerInfo.getNativeManagementInterface().isEmpty() && this.hostControllerInfo.getNativeManagementPort() > 0) {
            interfaces.add(new DomainControllerManagementInterface(this.hostControllerInfo.getNativeManagementPort(), this.hostControllerInfo.getNativeManagementInterface(), Protocol.REMOTE));
        }
        if (this.hostControllerInfo.getHttpManagementSecureInterface() != null && !this.hostControllerInfo.getHttpManagementSecureInterface().isEmpty() && this.hostControllerInfo.getHttpManagementSecurePort() > 0) {
            interfaces.add(new DomainControllerManagementInterface(this.hostControllerInfo.getHttpManagementSecurePort(), this.hostControllerInfo.getHttpManagementSecureInterface(), Protocol.HTTPS_REMOTING));
        }
        if (this.hostControllerInfo.getHttpManagementInterface() != null && !this.hostControllerInfo.getHttpManagementInterface().isEmpty() && this.hostControllerInfo.getHttpManagementPort() > 0) {
            interfaces.add(new DomainControllerManagementInterface(this.hostControllerInfo.getHttpManagementPort(), this.hostControllerInfo.getHttpManagementInterface(), Protocol.HTTP_REMOTING));
        }
        DiscoveryService.install(serviceTarget, discoveryOptions, interfaces, this.hostControllerInfo.isMasterDomainController());
    }

    private void connectToDomainMaster(ServiceTarget serviceTarget, RunningMode currentRunningMode) {
        Future<MasterDomainControllerClient> clientFuture = RemoteDomainConnectionService.install(serviceTarget, this.getValue(), this.extensionRegistry, this.hostControllerInfo, this.hostControllerInfo.getRemoteDomainControllerSecurityRealm(), this.remoteFileRepository, this.contentRepository, this.ignoredRegistry, new InternalExecutor(), this, this.environment, (ExecutorService)this.getExecutorServiceInjector().getValue(), currentRunningMode, this.serverProxies, this.domainModelComplete);
        MasterDomainControllerClient masterDomainControllerClient = this.getFuture(clientFuture);
        try {
            masterDomainControllerClient.register();
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.cannotConnectToMaster(e);
            if (currentRunningMode == RunningMode.ADMIN_ONLY) {
                HostControllerLogger.ROOT_LOGGER.fetchConfigFromDomainMasterFailed(currentRunningMode, "admin-only-policy", AdminOnlyDomainConfigPolicy.REQUIRE_LOCAL_CONFIG, "--cached-dc");
            }
            SystemExiter.abort(99);
        }
    }

    protected AbstractControllerService.ModelControllerServiceInitializationParams getModelControllerServiceInitializationParams() {
        ServiceLoader<ModelControllerServiceInitialization> sl = ServiceLoader.load(ModelControllerServiceInitialization.class);
        return new AbstractControllerService.ModelControllerServiceInitializationParams(sl){

            public String getHostName() {
                return DomainModelControllerService.this.hostControllerInfo.getLocalHostName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishServerInventory(Future<ServerInventory> future) {
        DelegatingServerInventory dse = new DelegatingServerInventory();
        AtomicBoolean atomicBoolean = this.serverInventoryLock;
        synchronized (atomicBoolean) {
            try {
                this.serverInventory = this.getFuture(future);
                this.serverInventoryLock.set(true);
            }
            finally {
                this.serverInventoryLock.notifyAll();
            }
        }
    }

    private <T> T getFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void startServers() {
        ModelNode addr = new ModelNode();
        addr.add("host", this.hostControllerInfo.getLocalHostName());
        ModelNode op = Util.getEmptyOperation((String)"start-servers", (ModelNode)addr);
        this.getValue().execute(op, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        AtomicBoolean atomicBoolean = this.serverInventoryLock;
        synchronized (atomicBoolean) {
            try {
                this.serverInventory = null;
                this.serverInventoryLock.set(false);
            }
            finally {
                this.serverInventoryLock.notifyAll();
            }
        }
        this.extensionRegistry.clear();
        this.domainModelComplete.set(false);
        super.stop(context);
    }

    protected void stopAsynchronous(StopContext context) {
        this.pingScheduler.shutdownNow();
    }

    @Override
    public void stopLocalHost() {
        this.stopLocalHost(0);
    }

    @Override
    public void stopLocalHost(int exitCode) {
        ProcessControllerClient client = ((ProcessControllerConnectionService)this.injectedProcessControllerConnection.getValue()).getClient();
        this.processState.setStopping();
        try {
            client.shutdown(exitCode);
        }
        catch (IOException e) {
            throw HostControllerLogger.ROOT_LOGGER.errorClosingDownHost(e);
        }
    }

    @Override
    public void registerHostModel(String hostName, ManagementResourceRegistration root) {
        this.hostModelRegistration = HostModelUtil.createHostRegistry(hostName, root, this.hostControllerConfigurationPersister, this.environment, this.runningModeControl, this.localFileRepository, this.hostControllerInfo, new DelegatingServerInventory(), this.remoteFileRepository, this.contentRepository, this, this.hostExtensionRegistry, this.extensionRegistry, this.vaultReader, this.ignoredRegistry, this.processState, this.pathManager, this.authorizer, this.getAuditLogger(), this.getBootErrorCollector());
    }

    @Override
    public void initializeMasterDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        this.initializeDomainResource(root, configurationPersister, contentRepository, fileRepository, true, this.hostControllerInfo, extensionRegistry, null, pathManager);
    }

    @Override
    public void initializeSlaveDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManagery) {
        this.initializeDomainResource(root, configurationPersister, contentRepository, fileRepository, false, hostControllerInfo, extensionRegistry, ignoredDomainResourceRegistry, this.pathManager);
    }

    private void initializeDomainResource(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepo, HostFileRepository fileRepository, boolean isMaster, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        DomainRootDefinition domainRootDefinition = new DomainRootDefinition(this, this.environment, configurationPersister, contentRepo, fileRepository, isMaster, hostControllerInfo, extensionRegistry, ignoredDomainResourceRegistry, pathManager, this.authorizer, this, this.domainHostExcludeRegistry, this.getMutableRootResourceRegistrationProvider());
        this.rootResourceDefinition.setDelegate(domainRootDefinition, root);
    }

    private static AbstractVaultReader loadVaultReaderService() {
        ServiceLoader<AbstractVaultReader> serviceLoader = ServiceLoader.load(AbstractVaultReader.class, DomainModelControllerService.class.getClassLoader());
        Iterator<AbstractVaultReader> it = serviceLoader.iterator();
        ServiceConfigurationError sce = null;
        while (it.hasNext()) {
            try {
                return it.next();
            }
            catch (ServiceConfigurationError e) {
                if (sce != null) continue;
                sce = e;
            }
        }
        if (sce != null) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf(sce, "Cannot instantiate provider of service %s", AbstractVaultReader.class);
        }
        return null;
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    @Override
    public ImmutableCapabilityRegistry getCapabilityRegistry() {
        return this.capabilityRegistry;
    }

    @Override
    public ExpressionResolver getExpressionResolver() {
        return this.expressionResolver;
    }

    private FutureServerInventory getPlaceHolderInventory() {
        FutureServerInventory future = new FutureServerInventory();
        ServerInventory inventory = new ServerInventory(){

            @Override
            public String getServerProcessName(String serverName) {
                return ManagedServer.getServerProcessName(serverName);
            }

            @Override
            public String getProcessServerName(String processName) {
                return ManagedServer.getServerName(processName);
            }

            @Override
            public Map<String, ProcessInfo> determineRunningProcesses() {
                return Collections.emptyMap();
            }

            @Override
            public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
                return Collections.emptyMap();
            }

            @Override
            public ServerStatus determineServerStatus(String serverName) {
                return ServerStatus.STOPPED;
            }

            @Override
            public ServerStatus startServer(String serverName, ModelNode domainModel) {
                return ServerStatus.STOPPED;
            }

            @Override
            public ServerStatus startServer(String serverName, ModelNode domainModel, boolean blocking) {
                return ServerStatus.STOPPED;
            }

            @Override
            public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
                return ServerStatus.STOPPED;
            }

            @Override
            public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel, boolean blocking) {
                return ServerStatus.STOPPED;
            }

            @Override
            public ServerStatus stopServer(String serverName, int gracefulTimeout) {
                return ServerStatus.STARTED;
            }

            @Override
            public ServerStatus stopServer(String serverName, int gracefulTimeout, boolean blocking) {
                return ServerStatus.STARTED;
            }

            @Override
            public void stopServers(int gracefulTimeout) {
            }

            @Override
            public void stopServers(int gracefulTimeout, boolean blockUntilStopped) {
            }

            @Override
            public void reconnectServer(String serverName, ModelNode domainModel, String authKey, boolean running, boolean stopping) {
            }

            @Override
            public ServerStatus reloadServer(String serverName, boolean blocking) {
                return ServerStatus.STOPPED;
            }

            @Override
            public void destroyServer(String serverName) {
            }

            @Override
            public void killServer(String serverName) {
            }

            @Override
            public CallbackHandler getServerCallbackHandler() {
                CallbackHandler callback = new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    }
                };
                return callback;
            }

            @Override
            public ProxyController serverCommunicationRegistered(String serverProcessName, ManagementChannelHandler channelHandler) {
                return new ProxyController(){

                    public PathAddress getProxyNodeAddress() {
                        return null;
                    }

                    public void execute(ModelNode operation, OperationMessageHandler handler, ProxyController.ProxyOperationControl control, OperationAttachments attachments, BlockingTimeout blockingTimeout) {
                    }
                };
            }

            @Override
            public boolean serverReconnected(String serverProcessName, ManagementChannelHandler channelHandler) {
                return true;
            }

            @Override
            public void serverStarted(String serverProcessName) {
            }

            @Override
            public void serverStartFailed(String serverProcessName) {
            }

            @Override
            public void serverProcessStopped(String serverProcessName) {
            }

            @Override
            public void connectionFinished() {
            }

            @Override
            public void serverProcessAdded(String processName) {
            }

            @Override
            public void serverProcessStarted(String processName) {
            }

            @Override
            public void serverProcessRemoved(String processName) {
            }

            @Override
            public void operationFailed(String processName, ProcessMessageHandler.OperationType type) {
            }

            @Override
            public void processInventory(Map<String, ProcessInfo> processInfos) {
            }

            @Override
            public void awaitServersState(Collection<String> serverNames, boolean started) {
            }

            @Override
            public void suspendServer(String serverName) {
            }

            @Override
            public void resumeServer(String serverName) {
            }

            @Override
            public boolean awaitServerSuspend(Set<String> waitForServers, int timeout) {
                return false;
            }
        };
        future.setInventory(inventory);
        return future;
    }

    static {
        int poolSize = -1;
        try {
            poolSize = Integer.parseInt(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.domain.ping.pool.size", (String)"5"));
        }
        catch (Exception exception) {
        }
        finally {
            PINGER_POOL_SIZE = Math.max(1, poolSize);
        }
    }

    private class FutureServerInventory
    extends AsyncFutureTask<ServerInventory> {
        public FutureServerInventory() {
            super(null);
        }

        private void setInventory(ServerInventory inventory) {
            super.setResult((Object)inventory);
        }

        private void setFailure(Throwable t) {
            super.setFailed(t);
        }
    }

    private static final class DomainHostControllerInfoAccessor
    implements RuntimeHostControllerInfoAccessor {
        private final LocalHostControllerInfoImpl hostControllerInfo;

        public DomainHostControllerInfoAccessor(LocalHostControllerInfoImpl hostControllerInfo) {
            this.hostControllerInfo = hostControllerInfo;
        }

        public RuntimeHostControllerInfoAccessor.HostControllerInfo getHostControllerInfo(OperationContext context) throws OperationFailedException {
            if (context.isBooting() && context.getCurrentStage() == OperationContext.Stage.MODEL) {
                throw ControllerLogger.ROOT_LOGGER.onlyAccessHostControllerInfoInRuntimeStage();
            }
            return new RuntimeHostControllerInfoAccessor.HostControllerInfo(){

                public boolean isMasterHc() {
                    return hostControllerInfo.isMasterDomainController();
                }
            };
        }
    }

    final class InternalExecutor
    implements HostControllerRegistrationHandler.OperationExecutor,
    ServerToHostProtocolHandler.OperationExecutor,
    MasterDomainControllerOperationHandlerService.TransactionalOperationExecutor {
        InternalExecutor() {
        }

        @Override
        public ModelNode execute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler step) {
            return DomainModelControllerService.this.internalExecute(operation, handler, control, step).getResponseNode();
        }

        @Override
        public ModelNode installSlaveExtensions(List<ModelNode> extensions) {
            Operation operation = ApplyExtensionsHandler.getOperation(extensions);
            OperationStepHandler stepHandler = DomainModelControllerService.this.modelNodeRegistration.getOperationHandler(PathAddress.EMPTY_ADDRESS, "resolve-subsystems");
            return DomainModelControllerService.this.internalExecute(operation, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, stepHandler, false, true).getResponseNode();
        }

        @Override
        public ModelNode joinActiveOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler step, int permit) {
            return DomainModelControllerService.this.executeReadOnlyOperation(operation, handler, control, step, permit);
        }

        @Override
        public OperationResponse executeAndAttemptLock(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler step) {
            return DomainModelControllerService.this.internalExecute(operation, handler, control, step, true);
        }

        @Override
        public ModelNode executeReadOnly(ModelNode operation, OperationStepHandler handler, ModelController.OperationTransactionControl control) {
            return DomainModelControllerService.this.executeReadOnlyOperation(operation, control, handler);
        }

        @Override
        public ModelNode executeReadOnly(ModelNode operation, Resource model, OperationStepHandler handler, ModelController.OperationTransactionControl control) {
            return DomainModelControllerService.this.executeReadOnlyOperation(operation, model, control, handler);
        }

        @Override
        public void acquireReadlock(Integer operationID) throws IllegalArgumentException, InterruptedException {
            if (operationID == null) {
                throw HostControllerLogger.DOMAIN_LOGGER.nullVar("operationID");
            }
            DomainModelControllerService.this.acquireReadLock(operationID);
        }

        @Override
        public void releaseReadlock(Integer operationID) throws IllegalArgumentException {
            if (operationID == null) {
                throw HostControllerLogger.DOMAIN_LOGGER.nullVar("operationID");
            }
            DomainModelControllerService.this.releaseReadLock(operationID);
        }
    }

    private static class DomainDelegatingResourceDefinition
    extends DelegatingResourceDefinition {
        private DomainDelegatingResourceDefinition() {
        }

        void setDelegate(DomainRootDefinition delegate, ManagementResourceRegistration root) {
            super.setDelegate((ResourceDefinition)delegate);
            delegate.initialize(root);
        }

        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        }

        public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
        }
    }

    private class DelegatingServerInventory
    implements ServerInventory {
        private static final long SERVER_INVENTORY_TIMEOUT = 10000L;

        private DelegatingServerInventory() {
        }

        private synchronized ServerInventory getServerInventory() {
            if (DomainModelControllerService.this.processType == ProcessType.EMBEDDED_HOST_CONTROLLER) {
                return this.getServerInventory(true);
            }
            return this.getServerInventory(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized ServerInventory getServerInventory(boolean placeHolder) {
            try {
                if (placeHolder) {
                    return (ServerInventory)DomainModelControllerService.this.getPlaceHolderInventory().get();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServerInventory result = null;
            AtomicBoolean atomicBoolean = DomainModelControllerService.this.serverInventoryLock;
            synchronized (atomicBoolean) {
                if (DomainModelControllerService.this.serverInventoryLock.get()) {
                    result = DomainModelControllerService.this.serverInventory;
                } else {
                    try {
                        DomainModelControllerService.this.serverInventoryLock.wait(10000L);
                        if (DomainModelControllerService.this.serverInventoryLock.get()) {
                            result = DomainModelControllerService.this.serverInventory;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (result == null) {
                throw new IllegalStateException();
            }
            return result;
        }

        @Override
        public ProxyController serverCommunicationRegistered(String serverProcessName, ManagementChannelHandler channelHandler) {
            return this.getServerInventory().serverCommunicationRegistered(serverProcessName, channelHandler);
        }

        @Override
        public boolean serverReconnected(String serverProcessName, ManagementChannelHandler channelHandler) {
            return this.getServerInventory().serverReconnected(serverProcessName, channelHandler);
        }

        @Override
        public void serverProcessAdded(String serverProcessName) {
            this.getServerInventory().serverProcessAdded(serverProcessName);
        }

        @Override
        public void serverStartFailed(String serverProcessName) {
            this.getServerInventory().serverStartFailed(serverProcessName);
        }

        @Override
        public void serverStarted(String serverProcessName) {
            this.getServerInventory().serverStarted(serverProcessName);
        }

        @Override
        public void serverProcessStopped(String serverProcessName) {
            this.getServerInventory().serverProcessStopped(serverProcessName);
        }

        @Override
        public String getServerProcessName(String serverName) {
            return this.getServerInventory().getServerProcessName(serverName);
        }

        @Override
        public String getProcessServerName(String processName) {
            return this.getServerInventory().getProcessServerName(processName);
        }

        @Override
        public ServerStatus reloadServer(String serverName, boolean blocking) {
            return this.getServerInventory().reloadServer(serverName, blocking);
        }

        @Override
        public void processInventory(Map<String, ProcessInfo> processInfos) {
            this.getServerInventory().processInventory(processInfos);
        }

        @Override
        public Map<String, ProcessInfo> determineRunningProcesses() {
            return this.getServerInventory().determineRunningProcesses();
        }

        @Override
        public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
            return this.getServerInventory().determineRunningProcesses(serversOnly);
        }

        @Override
        public ServerStatus determineServerStatus(String serverName) {
            return this.getServerInventory().determineServerStatus(serverName);
        }

        @Override
        public ServerStatus startServer(String serverName, ModelNode domainModel) {
            return this.getServerInventory().startServer(serverName, domainModel);
        }

        @Override
        public ServerStatus startServer(String serverName, ModelNode domainModel, boolean blocking) {
            return this.getServerInventory().startServer(serverName, domainModel, blocking);
        }

        @Override
        public void reconnectServer(String serverName, ModelNode domainModel, String authKey, boolean running, boolean stopping) {
            this.getServerInventory().reconnectServer(serverName, domainModel, authKey, running, stopping);
        }

        @Override
        public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
            return this.getServerInventory().restartServer(serverName, gracefulTimeout, domainModel);
        }

        @Override
        public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel, boolean blocking) {
            return this.getServerInventory().restartServer(serverName, gracefulTimeout, domainModel, blocking);
        }

        @Override
        public ServerStatus stopServer(String serverName, int gracefulTimeout) {
            return this.getServerInventory().stopServer(serverName, gracefulTimeout);
        }

        @Override
        public ServerStatus stopServer(String serverName, int gracefulTimeout, boolean blocking) {
            return this.getServerInventory().stopServer(serverName, gracefulTimeout, blocking);
        }

        @Override
        public CallbackHandler getServerCallbackHandler() {
            return this.getServerInventory().getServerCallbackHandler();
        }

        @Override
        public void stopServers(int gracefulTimeout) {
            this.getServerInventory().stopServers(gracefulTimeout);
        }

        @Override
        public void stopServers(int gracefulTimeout, boolean blockUntilStopped) {
            this.getServerInventory().stopServers(gracefulTimeout, blockUntilStopped);
        }

        @Override
        public void connectionFinished() {
            this.getServerInventory().connectionFinished();
        }

        @Override
        public void serverProcessStarted(String processName) {
            this.getServerInventory().serverProcessStarted(processName);
        }

        @Override
        public void serverProcessRemoved(String processName) {
            this.getServerInventory().serverProcessRemoved(processName);
        }

        @Override
        public void operationFailed(String processName, ProcessMessageHandler.OperationType type) {
            this.getServerInventory().operationFailed(processName, type);
        }

        @Override
        public void destroyServer(String serverName) {
            this.getServerInventory().destroyServer(serverName);
        }

        @Override
        public void killServer(String serverName) {
            this.getServerInventory().killServer(serverName);
        }

        @Override
        public void awaitServersState(Collection<String> serverNames, boolean started) {
            this.getServerInventory().awaitServersState(serverNames, started);
        }

        @Override
        public void suspendServer(String serverName) {
            this.getServerInventory().suspendServer(serverName);
        }

        @Override
        public void resumeServer(String serverName) {
            this.getServerInventory().resumeServer(serverName);
        }

        @Override
        public boolean awaitServerSuspend(Set<String> waitForServers, int timeout) {
            return this.getServerInventory().awaitServerSuspend(waitForServers, timeout);
        }
    }
}

