/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanFactory;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupFactory;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.registry.Registry;

public class InfinispanBeanManagerFactory<I, T>
implements BeanManagerFactory<I, T, TransactionBatch> {
    private final InfinispanBeanManagerFactoryConfiguration configuration;

    public InfinispanBeanManagerFactory(InfinispanBeanManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public BeanManager<I, T, TransactionBatch> createBeanManager(IdentifierFactory<I> identifierFactory, final PassivationListener<T> passivationListener, final RemoveListener<T> removeListener) {
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext(this.configuration.getMarshallingConfigurationRepository(), this.configuration.getBeanContext().getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        Cache beanCache = this.configuration.getCache();
        Cache groupCache = this.configuration.getCache();
        InfinispanCacheProperties properties = new InfinispanCacheProperties(groupCache.getCacheConfiguration());
        final String beanName = this.configuration.getBeanContext().getBeanName();
        InfinispanBeanGroupFactory groupFactory = new InfinispanBeanGroupFactory(groupCache, beanCache, (MarshalledValueFactory<MarshallingContext>)factory, (MarshallingContext)context, (CacheProperties)properties);
        SimpleConfiguration groupConfiguration = new SimpleConfiguration(groupCache, groupFactory);
        InfinispanBeanFactory beanFactory = new InfinispanBeanFactory(beanName, groupFactory, beanCache, (CacheProperties)properties, this.configuration.getBeanContext().getTimeout(), properties.isPersistent() ? passivationListener : null);
        SimpleConfiguration beanConfiguration = new SimpleConfiguration(beanCache, beanFactory);
        final NodeFactory<Address> nodeFactory = this.configuration.getNodeFactory();
        final Registry<String, ?> registry = this.configuration.getRegistry();
        final KeyAffinityServiceFactory affinityFactory = this.configuration.getKeyAffinityServiceFactory();
        final CommandDispatcherFactory dispatcherFactory = this.configuration.getCommandDispatcherFactory();
        final Time timeout = this.configuration.getBeanContext().getTimeout();
        final ScheduledExecutorService scheduler = this.configuration.getScheduler();
        final ExpirationConfiguration expiration = new ExpirationConfiguration<T>(){

            @Override
            public Time getTimeout() {
                return timeout;
            }

            @Override
            public RemoveListener<T> getRemoveListener() {
                return removeListener;
            }

            @Override
            public ScheduledExecutorService getExecutor() {
                return scheduler;
            }
        };
        final Executor executor = this.configuration.getExecutor();
        final BeanPassivationConfiguration passivationConfig = this.configuration.getPassivationConfiguration();
        final PassivationConfiguration passivation = new PassivationConfiguration<T>(){

            @Override
            public PassivationListener<T> getPassivationListener() {
                return passivationListener;
            }

            @Override
            public BeanPassivationConfiguration getConfiguration() {
                return passivationConfig;
            }

            @Override
            public Executor getExecutor() {
                return executor;
            }
        };
        InfinispanBeanManagerConfiguration configuration = new InfinispanBeanManagerConfiguration<T>((CacheProperties)properties){
            final /* synthetic */ CacheProperties val$properties;
            {
                this.val$properties = cacheProperties;
            }

            @Override
            public String getBeanName() {
                return beanName;
            }

            @Override
            public KeyAffinityServiceFactory getAffinityFactory() {
                return affinityFactory;
            }

            @Override
            public Registry<String, ?> getRegistry() {
                return registry;
            }

            @Override
            public NodeFactory<Address> getNodeFactory() {
                return nodeFactory;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            @Override
            public ExpirationConfiguration<T> getExpirationConfiguration() {
                return expiration;
            }

            @Override
            public PassivationConfiguration<T> getPassivationConfiguration() {
                return passivation;
            }

            @Override
            public CacheProperties getProperties() {
                return this.val$properties;
            }
        };
        return new InfinispanBeanManager(configuration, identifierFactory, beanConfiguration, groupConfiguration);
    }

    private static class SimpleConfiguration<K, V, F>
    implements Configuration<K, V, F> {
        private final F factory;
        private final Cache<K, V> cache;

        SimpleConfiguration(Cache<K, V> cache, F factory) {
            this.factory = factory;
            this.cache = cache;
        }

        @Override
        public F getFactory() {
            return this.factory;
        }

        @Override
        public Cache<K, V> getCache() {
            return this.cache;
        }
    }
}

