/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.net.UnknownHostException;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.webservices.config.DisabledOperationException;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;

final class WSServerConfigAttributeHandler
extends AbstractWriteAttributeHandler<RollbackInfo> {
    public WSServerConfigAttributeHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<RollbackInfo> handbackHolder) throws OperationFailedException {
        if (this.isSameValue(context, resolvedValue, currentValue, attributeName) || context.isBooting()) {
            return false;
        }
        String value = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        boolean done = this.updateServerConfig(context, attributeName, value, false);
        handbackHolder.setHandback((Object)new RollbackInfo(done));
        return !done;
    }

    private boolean isSameValue(OperationContext context, ModelNode resolvedValue, ModelNode currentValue, String attributeName) throws OperationFailedException {
        if (resolvedValue.equals(this.getAttributeDefinition(attributeName).resolveValue(context, currentValue))) {
            return true;
        }
        if (!currentValue.isDefined()) {
            return resolvedValue.equals(this.getAttributeDefinition(attributeName).getDefaultValue());
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, RollbackInfo handback) throws OperationFailedException {
        if (handback != null && handback.isRuntimeUpdated()) {
            String value = valueToRestore.isDefined() ? valueToRestore.asString() : null;
            try {
                this.updateServerConfig(context, attributeName, value, true);
            }
            catch (DisabledOperationException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    private boolean updateServerConfig(OperationContext context, String attributeName, String value, boolean isRevert) throws OperationFailedException, DisabledOperationException {
        block13: {
            ServerConfigImpl config = (ServerConfigImpl)((Object)context.getServiceRegistry(false).getRequiredService(WSServices.CONFIG_SERVICE).getValue());
            try {
                if ("modify-wsdl-address".equals(attributeName)) {
                    boolean modifyWSDLAddress = value != null && Boolean.parseBoolean(value);
                    config.setModifySOAPAddress(modifyWSDLAddress, isRevert);
                    break block13;
                }
                if ("wsdl-host".equals(attributeName)) {
                    String host = value != null ? value : null;
                    try {
                        config.setWebServiceHost(host, isRevert);
                        break block13;
                    }
                    catch (UnknownHostException e) {
                        throw new OperationFailedException(e.getMessage(), (Throwable)e);
                    }
                }
                if ("wsdl-port".equals(attributeName)) {
                    int port = value != null ? Integer.parseInt(value) : -1;
                    config.setWebServicePort(port, isRevert);
                    break block13;
                }
                if ("wsdl-secure-port".equals(attributeName)) {
                    int securePort = value != null ? Integer.parseInt(value) : -1;
                    config.setWebServiceSecurePort(securePort, isRevert);
                    break block13;
                }
                if ("wsdl-path-rewrite-rule".equals(attributeName)) {
                    String path = value != null ? value : null;
                    config.setWebServicePathRewriteRule(path, isRevert);
                    break block13;
                }
                if ("wsdl-uri-scheme".equals(attributeName)) {
                    if (value == null || value.equals("http") || value.equals("https")) {
                        config.setWebServiceUriScheme(value, isRevert);
                        break block13;
                    }
                    throw new IllegalArgumentException(attributeName + " = " + value);
                }
                if ("statistics-enabled".equals(attributeName)) {
                    boolean enabled = value != null ? Boolean.parseBoolean(value) : false;
                    config.setStatisticsEnabled(enabled);
                    break block13;
                }
                throw new IllegalArgumentException(attributeName);
            }
            catch (DisabledOperationException doe) {
                if (!isRevert) {
                    return false;
                }
                throw doe;
            }
        }
        return true;
    }

    static class RollbackInfo {
        private final boolean runtimeUpdated;

        public RollbackInfo(boolean runtimeUpdated) {
            this.runtimeUpdated = runtimeUpdated;
        }

        public boolean isRuntimeUpdated() {
            return this.runtimeUpdated;
        }
    }
}

