/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.ClassLoaderThreadFactory;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ThreadPoolBuilder
extends CacheContainerComponentBuilder<ThreadPoolConfiguration>
implements ResourceServiceBuilder<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ThreadPoolDefinition definition;

    ThreadPoolBuilder(ThreadPoolDefinition definition, String containerName) {
        super(definition, containerName);
        this.definition = definition;
    }

    public Builder<ThreadPoolConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        BlockingThreadPoolExecutorFactory factory = new BlockingThreadPoolExecutorFactory(((AttributeDefinition)this.definition.getMaxThreads().getDefinition()).resolveModelAttribute(context, model).asInt(), ((AttributeDefinition)this.definition.getMinThreads().getDefinition()).resolveModelAttribute(context, model).asInt(), ((AttributeDefinition)this.definition.getQueueLength().getDefinition()).resolveModelAttribute(context, model).asInt(), ((AttributeDefinition)this.definition.getKeepAliveTime().getDefinition()).resolveModelAttribute(context, model).asLong()){

            public ExecutorService createExecutor(ThreadFactory factory) {
                return super.createExecutor((ThreadFactory)new ClassLoaderThreadFactory(factory, ClassLoaderThreadFactory.class.getClassLoader()));
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    public ThreadPoolConfiguration getValue() {
        return this.builder.create();
    }
}

