/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.filter.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.registry.CacheRegistryFactoryConfiguration;
import org.wildfly.clustering.server.registry.CacheRegistryFilter;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;

@Listener(sync=false)
public class CacheRegistry<K, V>
implements Registry<K, V>,
KeyFilter<Object> {
    private final List<Registry.Listener<K, V>> listeners = new CopyOnWriteArrayList<Registry.Listener<K, V>>();
    private final Cache<Node, Map.Entry<K, V>> cache;
    private final Batcher<? extends Batch> batcher;
    private final Group group;
    private final NodeFactory<Address> factory;
    private final CacheRegistryFilter filter = new CacheRegistryFilter();
    private final ServiceExecutor executor = new StampedLockServiceExecutor();

    public CacheRegistry(CacheRegistryFactoryConfiguration<K, V> config, RegistryEntryProvider<K, V> provider) {
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.group = config.getGroup();
        this.factory = config.getNodeFactory();
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)this.group.getLocalNode(), new AbstractMap.SimpleImmutableEntry<Object, Object>(provider.getKey(), provider.getValue()));
        }
        this.cache.addListener((Object)this, (KeyFilter)this.filter);
    }

    public boolean accept(Object key) {
        return key instanceof Node;
    }

    public void close() {
        this.executor.close(() -> {
            this.cache.removeListener((Object)this);
            this.listeners.clear();
            Node node = this.getGroup().getLocalNode();
            try (Batch batch = this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).remove((Object)node);
            }
        });
    }

    public void addListener(Registry.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Registry.Listener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        Set nodes = this.group.getNodes().stream().collect(Collectors.toSet());
        return this.cache.getAdvancedCache().getAll(nodes).values().stream().collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue()));
    }

    public Map.Entry<K, V> getEntry(Node node) {
        return (Map.Entry)this.cache.get((Object)node);
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<Node, Map.Entry<K, V>> event) {
        if (event.isPre()) {
            return;
        }
        this.executor.execute(() -> {
            ConsistentHash hash = event.getConsistentHashAtEnd();
            List members = hash.getMembers();
            HashSet addresses = new HashSet(event.getConsistentHashAtStart().getMembers());
            addresses.removeAll(members);
            if (!addresses.isEmpty()) {
                Address localAddress = event.getCache().getCacheManager().getAddress();
                List<Node> nodes = addresses.stream().filter(address -> hash.locatePrimaryOwner(address).equals(localAddress)).map(address -> this.factory.createNode(address)).collect(Collectors.toList());
                if (!nodes.isEmpty()) {
                    AdvancedCache cache = event.getCache().getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS});
                    HashMap removed = new HashMap();
                    try (Batch batch = this.batcher.createBatch();){
                        for (Node node : nodes) {
                            Map.Entry old = (Map.Entry)cache.remove((Object)node);
                            if (old == null) continue;
                            removed.put(old.getKey(), old.getValue());
                        }
                    }
                    catch (CacheException e) {
                        ClusteringServerLogger.ROOT_LOGGER.registryPurgeFailed(e, event.getCache().getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), event.getCache().getName(), nodes);
                    }
                    if (!removed.isEmpty()) {
                        this.notifyListeners(Event.Type.CACHE_ENTRY_REMOVED, removed);
                    }
                }
            }
        });
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void event(CacheEntryEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<Node, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (event.isOriginLocal() || event.isPre()) {
            return;
        }
        if (!this.listeners.isEmpty() && (entry = (Map.Entry)event.getOldValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
    }

    private void notifyListeners(Event.Type type, Map.Entry<K, V> entry) {
        this.notifyListeners(type, Collections.singletonMap(entry.getKey(), entry.getValue()));
    }

    private void notifyListeners(Event.Type type, Map<K, V> entries) {
        for (Registry.Listener<K, V> listener : this.listeners) {
            try {
                switch (type) {
                    case CACHE_ENTRY_CREATED: {
                        listener.addedEntries(entries);
                        break;
                    }
                    case CACHE_ENTRY_MODIFIED: {
                        listener.updatedEntries(entries);
                        break;
                    }
                    case CACHE_ENTRY_REMOVED: {
                        listener.removedEntries(entries);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(type.name());
                    }
                }
            }
            catch (Throwable e) {
                ClusteringServerLogger.ROOT_LOGGER.registryListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), this.cache.getName(), type, entries);
            }
        }
    }
}

