/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.io.File;
import java.util.List;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class RelativePathService
extends AbstractPathService {
    private final String relativePath;
    private final InjectedValue<String> injectedPath = new InjectedValue();

    public static ServiceController<String> addService(String name, String relativePath, String relativeTo, ServiceTarget serviceTarget) {
        return RelativePathService.addService(RelativePathService.pathNameOf(name), relativePath, false, relativeTo, serviceTarget, null, new ServiceListener[0]);
    }

    public static ServiceController<String> addService(String name, String relativePath, String relativeTo, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceListener ... listeners) {
        return RelativePathService.addService(RelativePathService.pathNameOf(name), relativePath, false, relativeTo, serviceTarget, newControllers, listeners);
    }

    public static ServiceController<String> addService(ServiceName name, String relativePath, String relativeTo, ServiceTarget serviceTarget) {
        return RelativePathService.addService(name, relativePath, false, relativeTo, serviceTarget, null, new ServiceListener[0]);
    }

    public static ServiceController<String> addService(ServiceName name, String path, boolean possiblyAbsolute, String relativeTo, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers, ServiceListener ... listeners) {
        if (possiblyAbsolute && RelativePathService.isAbsoluteUnixOrWindowsPath(path)) {
            return AbsolutePathService.addService(name, path, serviceTarget, newControllers, listeners);
        }
        RelativePathService service = new RelativePathService(path);
        ServiceBuilder builder = serviceTarget.addService(name, (Service)service).addDependency(RelativePathService.pathNameOf(relativeTo), String.class, service.injectedPath);
        if (listeners != null) {
            for (ServiceListener listener : listeners) {
                builder.addListener(listener);
            }
        }
        ServiceController svc = builder.install();
        if (newControllers != null) {
            newControllers.add(svc);
        }
        return svc;
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String relativePath = element.require("path").asString();
        String relativeTo = element.require("relative-to").asString();
        RelativePathService.addService(name, relativePath, false, relativeTo, serviceTarget, null, new ServiceListener[0]);
    }

    static String convertPath(String relativePath) {
        if (relativePath == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("relativePath");
        }
        if (relativePath.length() == 0) {
            throw ControllerLogger.ROOT_LOGGER.emptyVar("relativePath");
        }
        if (relativePath.charAt(0) == '/') {
            if (relativePath.length() == 1) {
                throw ControllerLogger.ROOT_LOGGER.invalidRelativePathValue(relativePath);
            }
            return relativePath.substring(1);
        }
        if (relativePath.indexOf(":\\") == 1) {
            throw ControllerLogger.ROOT_LOGGER.pathIsAWindowsAbsolutePath(relativePath);
        }
        if (RelativePathService.isWindows()) {
            return relativePath.replace("/", File.separator);
        }
        return relativePath.replace("\\", File.separator);
    }

    static String doResolve(String base, String relativePath) {
        base = base.endsWith(File.separator) ? base.substring(0, base.length() - 1) : base;
        return base + File.separatorChar + relativePath;
    }

    public RelativePathService(String relativePath) {
        this.relativePath = RelativePathService.convertPath(relativePath);
    }

    @Override
    protected String resolvePath() {
        return RelativePathService.doResolve((String)this.injectedPath.getValue(), this.relativePath);
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

